/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import org.clazzes.login.jbo.jwt.JWTokenClaims;
import org.clazzes.login.oauth.OAuthPrincipal;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.RefreshState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginInfo {
    private static final Logger log = LoggerFactory.getLogger(LoginInfo.class);
    private final String sessionId;
    private OAuthPrincipal principal;
    private OAuthTokenResponse response;
    private Locale locale;
    private TimeZone timeZone;
    private long expires;
    private RefreshState refreshState;

    public LoginInfo(String sessionId, Locale locale, TimeZone timeZone) {
        this.sessionId = sessionId;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public synchronized OAuthPrincipal getPrincipal() {
        return this.principal;
    }

    public synchronized OAuthTokenResponse getResponse() {
        return this.response;
    }

    public synchronized void setCredentials(OAuthTokenResponse response, OAuthPrincipal principal) {
        this.response = response;
        this.principal = principal;
        this.refreshState = this.response == null || this.principal == null ? RefreshState.FAILED : RefreshState.CURRENT;
        this.notifyAll();
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized TimeZone getTimeZone() {
        return this.timeZone;
    }

    public synchronized OAuthTokenResponse checkTokenValidity(long timeout) throws TimeoutException {
        JWTokenClaims claims;
        long watermark;
        if (this.refreshState == RefreshState.UPDATING) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new TimeoutException();
            }
        }
        if (this.refreshState != RefreshState.CURRENT) {
            throw new TimeoutException("Refresh of tokens for principal [" + this.principal.getName() + "] failed in a concurrent operation.");
        }
        boolean expired = false;
        long now = System.currentTimeMillis();
        if (this.response.getExpiresIn() != null && (watermark = this.response.getTimestamp() + this.response.getExpiresIn()) <= now) {
            log.info("access token for principal [{}] expired by response timeout.", (Object)this.principal.getName());
            expired = true;
        }
        if (!expired && this.principal.getIdToken() != null && (claims = this.principal.getIdToken().getClaimSet()).getExpiration() != null && claims.getExpiration() <= now) {
            log.info("ID token for principal [{}] expired by expiration claim.", (Object)this.principal.getName());
            expired = true;
        }
        if (expired) {
            if (this.response.getRefreshToken() == null) {
                throw new TimeoutException("ID token for principal [" + this.principal.getName() + "] expired without a refresh token.");
            }
            this.refreshState = RefreshState.UPDATING;
            return this.response;
        }
        return null;
    }

    public synchronized long getExpires() {
        return this.expires;
    }

    public synchronized void touch(long maxAge) {
        this.expires = System.currentTimeMillis() + maxAge;
    }

    public synchronized String getPrincipalsInfo() {
        if (this.principal == null) {
            return "<no principal>";
        }
        return this.principal.getName();
    }
}

