/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.clazzes.login.jbo.json.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigParser {
    private static final Logger log = LoggerFactory.getLogger(JsonConfigParser.class);

    public static final Map<String, Object> parseConfig(InputStream is) throws IOException {
        JsonFactory jf = new JsonFactory();
        String ctxt = "config";
        try (JsonParser reader = jf.createParser(is);){
            String name;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            JsonHelper.beginObject((JsonParser)reader, (String)ctxt);
            block13: while ((name = JsonHelper.nextName((JsonParser)reader, (String)ctxt)) != null) {
                JsonToken tokenType = reader.nextToken();
                switch (tokenType) {
                    case VALUE_NULL: {
                        ret.put(name, null);
                        continue block13;
                    }
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        ret.put(name, reader.getBooleanValue());
                        continue block13;
                    }
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        ret.put(name, reader.getDoubleValue());
                        continue block13;
                    }
                    case VALUE_STRING: {
                        ret.put(name, reader.getText());
                        continue block13;
                    }
                    case START_ARRAY: {
                        ArrayList<String> arr = new ArrayList<String>();
                        while (reader.nextToken().isScalarValue()) {
                            arr.add(reader.getText());
                        }
                        JsonHelper.endArray((JsonParser)reader, (String)name);
                        ret.put(name, arr);
                        continue block13;
                    }
                    case START_OBJECT: {
                        String key;
                        HashMap<String, String> map = new HashMap<String, String>();
                        while ((key = JsonHelper.nextName((JsonParser)reader, (String)ctxt)) != null) {
                            String value = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
                            map.put(key, value);
                        }
                        JsonHelper.endObject((JsonParser)reader, (String)ctxt);
                        ret.put(name, map);
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unsupported configuration member type [" + String.valueOf(tokenType) + "].");
            }
            JsonHelper.endObject((JsonParser)reader, (String)ctxt);
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }

    public static final Map<String, Object> parseStringMap(InputStream is) throws IOException {
        JsonFactory jf = new JsonFactory();
        String ctxt = "config";
        try (JsonParser reader = jf.createParser(is);){
            String name;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            JsonHelper.beginObject((JsonParser)reader, (String)ctxt);
            block12: while ((name = JsonHelper.nextName((JsonParser)reader, (String)ctxt)) != null) {
                JsonToken tokenType = reader.nextToken();
                switch (tokenType) {
                    case VALUE_NULL: {
                        ret.put(name, null);
                        continue block12;
                    }
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        ret.put(name, reader.getBooleanValue());
                        continue block12;
                    }
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        ret.put(name, reader.getDoubleValue());
                        continue block12;
                    }
                    case VALUE_STRING: {
                        ret.put(name, reader.getText());
                        continue block12;
                    }
                    case START_ARRAY: {
                        ArrayList<String> arr = new ArrayList<String>();
                        while (reader.nextToken().isScalarValue()) {
                            arr.add(reader.getText());
                        }
                        JsonHelper.endArray((JsonParser)reader, (String)name);
                        ret.put(name, arr);
                        continue block12;
                    }
                }
                log.warn("Ignoring unknown property [{}] in string map response.", (Object)name);
                reader.skipChildren();
            }
            JsonHelper.endObject((JsonParser)reader, (String)ctxt);
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }

    public static final Map<String, String> parseAppUsers(String appUsers) {
        String[] parts;
        if (appUsers == null) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String part : parts = appUsers.trim().split("\\s*,\\s*")) {
            if (part.isEmpty()) continue;
            String[] appUser = part.split("\\s*:\\s*", 2);
            if (appUser.length != 2) {
                throw new IllegalArgumentException("Invalid app user stanza [" + String.valueOf(appUser) + "] without colon.");
            }
            ret.put(appUser[0], appUser[1]);
        }
        return ret;
    }
}

