/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.DomainConfig;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.JsonConfigParser;
import org.clazzes.login.oauth.OAuthHttpClient;
import org.clazzes.login.oauth.RobotGrantType;
import org.clazzes.login.oauth.TokenValidator;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.sec.OAuthCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements Consumer<ConfigWrapper> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    private OAuthHttpClient oauthHttpClient;
    private TokenValidator tokenValidator;
    private final ServiceRegistry serviceRegistry;
    private final Map<String, DomainConfigRecord> domainConfigurations;
    private final List<String> guiDomains;
    public static final String CONFIG_PID = "org.clazzes.login.oauth";

    public ConfigurationService(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.domainConfigurations = new HashMap<String, DomainConfigRecord>();
        this.guiDomains = new ArrayList<String>();
    }

    private static final String makeRobotSupplierKey(String domain) {
        return "oauth.robot.token." + domain;
    }

    private void stopOpenIdJobs() {
        for (Map.Entry<String, DomainConfigRecord> e : this.domainConfigurations.entrySet()) {
            String robotKey = e.getValue().getRobotSupplierKey();
            if (robotKey == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Unregistering robot token supplier for domain [{}] with key [{}]", (Object)e.getKey(), (Object)robotKey);
            }
            this.serviceRegistry.removeService(robotKey, Supplier.class);
            e.getValue().setRobotSupplierKey(null);
        }
    }

    private void startOpenIdJobs() {
        for (Map.Entry<String, DomainConfigRecord> e : this.domainConfigurations.entrySet()) {
            DomainManager domainManager = e.getValue().getDomainManager();
            if (!domainManager.getDomainConfig().isRobot()) continue;
            Supplier<? extends OAuthCredentials> supplier = domainManager.getCredentialsSupplier();
            String robotKey = ConfigurationService.makeRobotSupplierKey(e.getKey());
            if (log.isDebugEnabled()) {
                log.debug("Registering robot token supplier for domain [{}] with key [{}]", (Object)e.getKey(), (Object)robotKey);
            }
            this.serviceRegistry.addService(robotKey, Supplier.class, supplier);
        }
    }

    private static URI getUri(ConfigWrapper properties, String key) {
        return (URI)properties.getParsed(URI::create, key);
    }

    private URI getFaviconLocation(ConfigWrapper domainProperties, URI configurationLocation, URI authorizationLocation) {
        URI faviconLocation = ConfigurationService.getUri(domainProperties, "faviconLocation");
        if (faviconLocation == null) {
            try {
                if (configurationLocation != null) {
                    faviconLocation = new URI(configurationLocation.getScheme(), null, configurationLocation.getHost(), configurationLocation.getPort(), "/favicon.ico", null, null);
                } else if (authorizationLocation != null) {
                    faviconLocation = new URI(authorizationLocation.getScheme(), null, authorizationLocation.getHost(), authorizationLocation.getPort(), "/favicon.ico", null, null);
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Couldn't guess the faviconLocation from the configurationLocation or the authoizationLocation, please specify it explicitly.", e);
            }
        }
        return faviconLocation;
    }

    private static PasswordAuthentication getPWAuth(String lbl, String user, String password) {
        if (user != null && password == null) {
            log.warn("No password for OAuth user role [{}] given, authentication will not work.", (Object)lbl);
        }
        if (user == null || password == null) {
            return null;
        }
        return new PasswordAuthentication(user, password.toCharArray());
    }

    private DomainConfig extractConfig(String domain, ConfigWrapper domainProperties) {
        String label = domainProperties.getMandatoryString("label");
        String clientId = domainProperties.getString("clientId");
        String clientpw = domainProperties.getString("clientPassword");
        PasswordAuthentication clientAuth = ConfigurationService.getPWAuth("client", clientId, clientpw);
        RobotGrantType robotGrantType = (RobotGrantType)domainProperties.getEnum(RobotGrantType.class, "robotGrantType");
        String robotClientId = domainProperties.getString("robotClientId");
        String robotClientPassword = domainProperties.getString("robotClientPassword");
        PasswordAuthentication robotAuth = robotGrantType != null && robotClientId != null ? ConfigurationService.getPWAuth("robotClient", robotClientId, robotClientPassword) : null;
        String robotUserId = domainProperties.getString("robotUserId");
        String robotUserPassword = domainProperties.getString("robotUserPassword");
        PasswordAuthentication robotUserCredentials = robotGrantType == RobotGrantType.password && robotUserId != null ? ConfigurationService.getPWAuth("robotUser", robotUserId, robotUserPassword) : null;
        URI configurationLocation = ConfigurationService.getUri(domainProperties, "configurationLocation");
        URI authorizationLocation = ConfigurationService.getUri(domainProperties, "authorizationLocation");
        URI tokenLocation = ConfigurationService.getUri(domainProperties, "tokenLocation");
        URI userLocation = ConfigurationService.getUri(domainProperties, "userLocation");
        URI faviconLocation = this.getFaviconLocation(domainProperties, configurationLocation, authorizationLocation);
        String scope = domainProperties.getString("scope");
        String prompt = domainProperties.getString("prompt");
        String accessType = domainProperties.getString("accessType");
        String resource = domainProperties.getString("resource");
        String groupRoleResource = domainProperties.getString("groupRoleResource");
        String optionsString = domainProperties.getString("options");
        EnumSet<ConfigOptions> options = ConfigOptions.parseOptions(optionsString);
        Map<String, String> appUsers = JsonConfigParser.parseAppUsers(domainProperties.getString("appUsers"));
        String robotScope = domainProperties.getString("robotScope");
        if (robotAuth == null && clientAuth == null) {
            throw new IllegalArgumentException("Neither a user nor a robot ClientID has been specified.");
        }
        if (authorizationLocation == null && configurationLocation == null && clientAuth != null) {
            throw new IllegalArgumentException("Neither an authorization URI nor a configuration URI has been given.");
        }
        if (userLocation == null && configurationLocation == null && clientAuth != null) {
            throw new IllegalArgumentException("Neither a user URI nor a configuration URI has been given.");
        }
        if (tokenLocation == null && configurationLocation == null) {
            throw new IllegalArgumentException("Neither a token URI nor a configuration URI has been given.");
        }
        if (log.isDebugEnabled()) {
            if (clientAuth != null) {
                log.debug("Setting bind credentials for domain [{}] to [{}].", (Object)domain, (Object)clientAuth.getUserName());
            }
            if (robotAuth != null) {
                log.debug("Setting robot bind credentials for domain [{}] to [{}] with grant type [{}].", new Object[]{domain, robotAuth.getUserName(), robotGrantType});
            }
            if (robotUserCredentials != null) {
                log.debug("Setting robot user credentials for domain [{}] to [{}].", (Object)domain, (Object)robotUserCredentials.getUserName());
            }
            log.debug("Setting configuration location for domain [{}] to [{}].", (Object)domain, (Object)configurationLocation);
            log.debug("Setting authorization location for domain [{}] to [{}].", (Object)domain, (Object)authorizationLocation);
            log.debug("Setting favicon location for domain [{}] to [{}].", (Object)domain, (Object)faviconLocation);
            log.debug("Setting token location for domain [{}] to [{}].", (Object)domain, (Object)tokenLocation);
            log.debug("Setting user location for domain [{}] to [{}].", (Object)domain, (Object)userLocation);
            log.debug("Setting scope for domain [{}] to [{}].", (Object)domain, (Object)scope);
            log.debug("Setting prompt for domain [{}] to [{}].", (Object)domain, (Object)prompt);
            log.debug("Setting accessType for domain [{}] to [{}].", (Object)domain, (Object)accessType);
            log.debug("Setting resource for domain [{}] to [{}].", (Object)domain, (Object)resource);
            log.debug("Setting groupRoleResource for domain [{}] to [{}].", (Object)domain, (Object)groupRoleResource);
            log.debug("Setting options for domain [{}] to [{}].", (Object)domain, options);
            log.debug("Setting appUsers for domain [{}] to [{}].", (Object)domain, appUsers);
            log.debug("Setting robot scope for domain [{}] to [{}].", (Object)domain, (Object)robotScope);
        }
        return new DomainConfig(domain, label, authorizationLocation, tokenLocation, userLocation, configurationLocation, faviconLocation, clientAuth, scope, prompt, accessType, resource, groupRoleResource, options, appUsers, robotGrantType, robotScope, robotAuth, robotUserCredentials);
    }

    @Override
    public void accept(ConfigWrapper t) {
        this.stopOpenIdJobs();
        this.domainConfigurations.clear();
        this.guiDomains.clear();
        ConfigWrapper domains = t.getSubTree("domain");
        if (domains == null) {
            log.warn("No domains configured in PID [{}], OAuth is deactivated.", (Object)CONFIG_PID);
            return;
        }
        for (String domain : domains.keySet()) {
            ConfigWrapper domainProperties = domains.getMandatorySubTree(domain);
            log.info("Extracting configuration for OAuth domain [{}]...", (Object)domain);
            if (log.isDebugEnabled()) {
                log.debug("Parsing domain properties [{}]", (Object)domainProperties);
            }
            DomainConfig config = this.extractConfig(domain, domainProperties);
            log.info("Final OAuth domain config is [{}].", (Object)config);
            this.domainConfigurations.put(domain, new DomainConfigRecord(new DomainManager(config, Clock.systemDefaultZone(), this.oauthHttpClient, this.tokenValidator), null));
            if (config.getClientCredentials() == null) continue;
            this.guiDomains.add(domain);
        }
        this.startOpenIdJobs();
    }

    public synchronized List<String> getDomains() {
        return new ArrayList<String>(this.guiDomains);
    }

    public synchronized DomainManager getDomainManager(String domain) {
        return Optional.ofNullable(this.domainConfigurations.get(domain)).map(r -> r.getDomainManager()).orElse(null);
    }

    public void setOauthHttpClient(OAuthHttpClient oauthHttpClient) {
        this.oauthHttpClient = oauthHttpClient;
    }

    public void setTokenValidator(TokenValidator tokenValidator) {
        this.tokenValidator = tokenValidator;
    }

    class DomainConfigRecord {
        private DomainManager domainManager;
        private String robotSupplierKey;

        public DomainConfigRecord(DomainManager domainManager, String robotSupplierKey) {
            this.domainManager = domainManager;
            this.robotSupplierKey = robotSupplierKey;
        }

        public DomainManager getDomainManager() {
            return this.domainManager;
        }

        public void setDomainManager(DomainManager domainManager) {
            this.domainManager = domainManager;
        }

        public String getRobotSupplierKey() {
            return this.robotSupplierKey;
        }

        public void setRobotSupplierKey(String robotSupplierKey) {
            this.robotSupplierKey = robotSupplierKey;
        }
    }
}

