package org.clazzes.login.oauth;

import org.clazzes.login.jbo.jwt.JWToken;
import org.clazzes.util.aop.i18n.Messages;

public interface TokenValidator {

    /**
     * Validate an OpenID token using the procedure of
     * <a href="http://openid.net/specs/openid-connect-core-1_0.html#IDTokenValidation">Section 3.1.3.7. "ID Token Validation" of the OpenID 1.0 Specification</a>
     *
     * This method uses the <code>clientId</code> for user flows.
     *
     * @param domainConfig The domain configuration.
     * @param response A parsed response from the token endpoint.
     * @param i18n The internationalization messages resource.
     * @return The parsed ID token, if the validation succeeded or <code>null</code>, if
     *         no ID token was contained in the token response.
     * @throws OAuthTokenErrorResponse Upon validation errors.
     */
    JWToken validateToken(DomainManager domainConfig,
            OAuthTokenResponse response, Messages i18n)
            throws OAuthTokenErrorResponse;

    /**
     * Validate an OpenID robot token using the procedure of
     * <a href="http://openid.net/specs/openid-connect-core-1_0.html#IDTokenValidation">Section 3.1.3.7. "ID Token Validation" of the OpenID 1.0 Specification</a>
     *
     * This method uses the <code>robotClientId</code> for unattended flows.
     *
     * @param domainConfig The domain configuration.
     * @param response A parsed response from the token endpoint.
     * @param i18n The internationalization messages resource.
     * @return The parsed ID token, if the validation succeeded or <code>null</code>, if
     *         no ID token was contained in the token response.
     * @throws OAuthTokenErrorResponse Upon validation errors.
     */
    JWToken validateRobotToken(DomainManager domainConfig,
            OAuthTokenResponse response, Messages i18n)
            throws OAuthTokenErrorResponse;
}
