/***********************************************************
 * $Id$
 * 
 * OAuth Login Services of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 16.03.2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.oauth;

import org.clazzes.util.sec.DomainGroup;

/**
 * An OAuth group as deduced from an OpenID Connect group claim.
 */
public class OAuthGroup implements DomainGroup {

    private final String domain;
    private final String groupName;
    
    public OAuthGroup(String domain, String groupName) {
        super();
        this.domain = domain;
        this.groupName = groupName;
    }

    @Override
    public String getName() {
        
        return this.domain + "/" + this.groupName;
    }

    @Override
    public String getGroupName() {
        
        return this.groupName;
    }

    @Override
    public String getDomain() {
        
        return this.domain;
    }

    @Override
    public String toString() {
        return "OAuthGroup [" + getName() + "]";
    }
    
}
