/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth.impl;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.jwt.JWKPubKey;
import org.clazzes.login.jbo.jwt.JWToken;
import org.clazzes.login.jbo.jwt.JWTokenClaims;
import org.clazzes.login.jbo.jwt.JWTokenParser;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.DomainConfig;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.TokenValidator;
import org.clazzes.util.aop.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTokenValidator
implements TokenValidator {
    private Clock clock = Clock.systemDefaultZone();
    private static final Logger log = LoggerFactory.getLogger(JWTokenValidator.class);

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public JWToken validateToken(DomainManager domainManager, OAuthTokenResponse response, Messages i18n) throws OAuthTokenErrorResponse {
        return this.validateTokenInternal(domainManager, response, i18n, domainManager.getDomainConfig().getClientCredentials().getUserName(), domainManager.getDomainConfig());
    }

    @Override
    public JWToken validateRobotToken(DomainManager domainManager, OAuthTokenResponse response, Messages i18n) throws OAuthTokenErrorResponse {
        return this.validateTokenInternal(domainManager, response, i18n, domainManager.getDomainConfig().getRobotCredentials().getUserName(), domainManager.getDomainConfig());
    }

    protected JWToken validateTokenInternal(DomainManager domainManager, OAuthTokenResponse response, Messages i18n, String clientId, DomainConfig domainConfig) throws OAuthTokenErrorResponse {
        try {
            Object[] audiences;
            Object tid;
            Map<String, Object> openIdConfiguration;
            String idToken;
            boolean jwt = "jwt".equals(response.getTokenType()) || domainConfig.getOptions().contains((Object)ConfigOptions.jwtAccessToken);
            String string = idToken = jwt ? response.getAccessToken() : response.getIdToken();
            if (idToken == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Validating {} token [{}].", (Object)(jwt ? "JWT" : "ID"), (Object)idToken);
            }
            JWToken token = JWTokenParser.parseJWToken((String)idToken);
            JWTokenClaims claims = token.getClaimSet();
            if (log.isDebugEnabled()) {
                log.debug("Checking signature on ID Token with issuer [{}] and key ID [{}]...", (Object)claims.getIssuer(), (Object)token.getKeyId());
            }
            if ((openIdConfiguration = domainManager.getOpenIdConfiguration()) == null) {
                log.error("OpenID configuration of domain [" + domainManager.getDomain() + "] not loaded while validation Open ID token.");
                throw new OAuthTokenErrorResponse("openid-configuration-not-loaded", i18n);
            }
            String domainIssuer = (String)openIdConfiguration.get("issuer");
            if (domainIssuer == null) {
                log.error("OpenID configuration of domain [" + domainManager.getDomain() + "] does not contain an [issuer] entry while validation Open ID token.");
                throw new OAuthTokenErrorResponse("openid-configuration-invalid", i18n);
            }
            if (domainIssuer.contains("{tenantid}") && (tid = claims.getAdditionalClaim("tid")) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Replacing {tenantid} in domain issuer [{}] with tid [{}]", (Object)domainIssuer, tid);
                }
                domainIssuer = domainIssuer.replace("{tenantid}", tid.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug("Checking domain issuer [{}] against token issuer [{}].", (Object)domainIssuer, (Object)claims.getIssuer());
            }
            if (!domainIssuer.equals(claims.getIssuer())) {
                if (jwt && openIdConfiguration.get("access_token_issuer") != null) {
                    Object tid2;
                    String tokenIssuer = (String)openIdConfiguration.get("access_token_issuer");
                    if (tokenIssuer.contains("{tenantid}") && (tid2 = claims.getAdditionalClaim("tid")) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Replacing {tenantid} in token issuer [{}] with tid [{}]", (Object)tokenIssuer, tid2);
                        }
                        tokenIssuer = tokenIssuer.replace("{tenantid}", tid2.toString());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Checking domain access_token_issuer [{}] against token issuer [{}].", (Object)tokenIssuer, (Object)claims.getIssuer());
                    }
                    if (!tokenIssuer.equals(claims.getIssuer())) {
                        log.error("Domain access_token_issuer [{}] differs from token issuer [{}] while validation Open ID token.", (Object)domainIssuer, (Object)claims.getIssuer());
                        throw new OAuthTokenErrorResponse("openid-token-invalid-issuer", i18n);
                    }
                } else {
                    log.error("Domain issuer [{}] differs from token issuer [{}] while validation Open ID token.", (Object)domainIssuer, (Object)claims.getIssuer());
                    throw new OAuthTokenErrorResponse("openid-token-invalid-issuer", i18n);
                }
            }
            if (!jwt && Arrays.binarySearch(audiences = Helpers.parseScope((String)claims.getAudience()), clientId) < 0) {
                log.error("Domain clientId [{}] is not contained in the token audience [{}] while validating Open ID token.", (Object)clientId, (Object)claims.getAudience());
                throw new OAuthTokenErrorResponse("openid-token-invalid-audience", i18n);
            }
            JWKPubKey pubKey = domainManager.getOpenIdKeys().get(token.getKeyId());
            if (pubKey == null) {
                throw new OAuthTokenErrorResponse("openid-token-unknown-key", i18n);
            }
            Object algorithmsSupported_o = openIdConfiguration.get("id_token_signing_alg_values_supported");
            if (algorithmsSupported_o == null || !(algorithmsSupported_o instanceof List)) {
                log.error("OpenID configuration of domain [" + domainManager.getDomain() + "] does not contain an [id_token_signing_alg_values_supported] entry of type array while validation Open ID token.");
                throw new OAuthTokenErrorResponse("openid-configuration-invalid", i18n);
            }
            List algorithmsSupported = (List)algorithmsSupported_o;
            Algorithm selectedAlgorithm = null;
            for (String rawAlgorithm : algorithmsSupported) {
                if (!token.getAlgorithm().toString().equals(rawAlgorithm)) continue;
                selectedAlgorithm = token.getAlgorithm();
                break;
            }
            if (selectedAlgorithm == null) {
                log.error("OpenID token algorithm [{}] not contained in [id_token_signing_alg_values_supported] entry of the OpenID configuration of domain [{}].", (Object)token.getAlgorithm(), (Object)domainManager.getDomain());
                throw new OAuthTokenErrorResponse("openid-token-validation-failed", i18n);
            }
            if (log.isDebugEnabled()) {
                log.debug("Checking token signature using algorithm [{}].", selectedAlgorithm);
            }
            Signature signature = Signature.getInstance(selectedAlgorithm.getJceName());
            signature.initVerify(pubKey.getPubKeyInfo().getPublicKey());
            signature.update(token.getSignaturePayload());
            boolean ok = signature.verify(token.getSignature());
            if (ok) {
                String accessToken;
                if (log.isDebugEnabled()) {
                    log.debug("Successfully checked signature on ID Token with key ID [{}], claims are [{}].", (Object)token.getKeyId(), (Object)claims);
                }
                String string2 = accessToken = jwt ? null : response.getAccessToken();
                if (accessToken != null) {
                    Object atHash = token.getClaimSet().getAdditionalClaim("at_hash");
                    if (atHash == null) {
                        if (!domainManager.getDomainConfig().getOptions().contains((Object)ConfigOptions.lenientAccessTokenCheck)) {
                            log.error("OpenID access token validation failed, no [at_hash] given in claims.");
                            throw new OAuthTokenErrorResponse("access-token-validation-failed", i18n);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Ignoring missing [at_hash] claim during open ID access token validation, because option [lenientAccessTokenCheck] is given.");
                        }
                    } else {
                        byte[] atDigestArray;
                        byte[] raw = accessToken.getBytes("US-ASCII");
                        String hashName = selectedAlgorithm.getHashName();
                        MessageDigest md = MessageDigest.getInstance(hashName);
                        byte[] digest = md.digest(raw);
                        byte[] hashArray = Arrays.copyOf(digest, digest.length / 2);
                        if (!Arrays.equals(hashArray, atDigestArray = Helpers.parseBase64((String)atHash.toString()))) {
                            log.error("OpenID access token validation failed, because [at_hash] value differs from actual acces token hash.");
                            throw new OAuthTokenErrorResponse("access-token-validation-failed", i18n);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Correctly validated access token against [at_hash] open ID access token.");
                        }
                    }
                }
                Long nbf = token.getClaimSet().getNotBefore();
                Long exp = token.getClaimSet().getExpiration();
                long now = Instant.now(this.clock).toEpochMilli();
                if (nbf != null && now < nbf) {
                    log.error("OpenID access token is not yet valid, nbf claim was [{}].", (Object)Helpers.formatTimeStamp((Long)nbf));
                    throw new OAuthTokenErrorResponse("openid-token-not-yet-valid", i18n);
                }
                if (exp != null && now > exp) {
                    log.error("OpenID access token has expired, exp claim was [{}].", (Object)Helpers.formatTimeStamp((Long)exp));
                    throw new OAuthTokenErrorResponse("openid-token-expired", i18n);
                }
                log.info("Correctly validated openID token valid from [{}] to [{}]", (Object)Helpers.formatTimeStamp((Long)nbf), (Object)Helpers.formatTimeStamp((Long)exp));
                return token;
            }
            log.error("OpenID token signature validation failed.");
            throw new OAuthTokenErrorResponse("openid-token-validation-failed", i18n);
        }
        catch (IOException | RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            log.error("Error validating OpenID token", (Throwable)e);
            throw new OAuthTokenErrorResponse("openid-token-validation-failed", i18n);
        }
    }
}

