/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Clock;
import java.util.Arrays;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthTokenResponseParser {
    private static final Logger log = LoggerFactory.getLogger(OAuthTokenResponseParser.class);

    private static OAuthTokenErrorResponse parseErrorInternal(JsonReader reader, String name) throws IOException {
        String error = null;
        String errorDescription = null;
        String errorUri = null;
        String timestamp = null;
        String traceId = null;
        String correlationId = null;
        long[] errorCodes = null;
        while (reader.hasNext()) {
            if (name == null) {
                name = reader.nextName();
            }
            if ("error".equals(name)) {
                error = reader.nextString();
            } else if ("error_description".equals(name)) {
                errorDescription = reader.nextString();
            } else if ("error_uri".equals(name)) {
                errorUri = reader.nextString();
            } else if ("timestamp".equals(name)) {
                timestamp = reader.nextString();
            } else if ("trace_id".equals(name)) {
                traceId = reader.nextString();
            } else if ("correlation_id".equals(name)) {
                correlationId = reader.nextString();
            } else if ("error_codes".equals(name)) {
                long[] tmp = new long[32];
                int ncodes = 0;
                reader.beginArray();
                while (reader.hasNext()) {
                    long code = reader.nextLong();
                    if (ncodes >= tmp.length) {
                        log.warn("Ignoring additonal error code [{}] (only 32 error codes are accepted in OAuth token error responses).", (Object)code);
                    } else {
                        tmp[ncodes] = code;
                    }
                    ++ncodes;
                }
                reader.endArray();
                errorCodes = Arrays.copyOf(tmp, ncodes);
            } else {
                log.warn("Ignoring unknown property [{}] in OAuth token response.", (Object)name);
                reader.skipValue();
            }
            name = null;
        }
        reader.endObject();
        return new OAuthTokenErrorResponse(error, errorDescription, errorUri, timestamp, traceId, correlationId, errorCodes);
    }

    public static OAuthTokenResponse parseResponse(InputStream is, String redirectUri, String state, String refreshToken, Clock clock) throws IOException, OAuthTokenErrorResponse {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));){
            String accessToken = null;
            String tokenType = null;
            Long expiresIn = null;
            String scope = null;
            String idToken = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("error".equals(name) || "error_description".equals(name)) {
                    throw OAuthTokenResponseParser.parseErrorInternal(reader, name);
                }
                if ("access_token".equals(name)) {
                    accessToken = reader.nextString();
                    continue;
                }
                if ("token_type".equals(name)) {
                    tokenType = reader.nextString();
                    continue;
                }
                if ("expires_in".equals(name)) {
                    expiresIn = reader.nextLong() * 1000L;
                    continue;
                }
                if ("scope".equals(name)) {
                    scope = reader.nextString();
                    continue;
                }
                if ("refresh_token".equals(name)) {
                    refreshToken = reader.nextString();
                    continue;
                }
                if ("id_token".equals(name)) {
                    idToken = reader.nextString();
                    continue;
                }
                log.warn("Ignoring unknown property [{}] in OAuth token response.", (Object)name);
                reader.skipValue();
            }
            reader.endObject();
            OAuthTokenResponse oAuthTokenResponse = new OAuthTokenResponse(accessToken, tokenType, expiresIn, scope, refreshToken, idToken, redirectUri, state, clock);
            return oAuthTokenResponse;
        }
    }

    public static OAuthTokenErrorResponse parseErrorResponse(InputStream is) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));){
            reader.beginObject();
            OAuthTokenErrorResponse oAuthTokenErrorResponse = OAuthTokenResponseParser.parseErrorInternal(reader, null);
            return oAuthTokenErrorResponse;
        }
    }
}

