/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.time.Clock;
import java.time.Instant;

public class OAuthTokenResponse {
    private final String accessToken;
    private final String tokenType;
    private final Long expiresIn;
    private final String scope;
    private final String refreshToken;
    private final String idToken;
    private final long timestamp;
    private final String redirectUri;
    private final String state;

    public OAuthTokenResponse(String accessToken, String tokenType, Long expiresIn, String scope, String refreshToken, String idToken, String redirectUri, String state, Clock clock) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.refreshToken = refreshToken;
        this.idToken = idToken;
        this.redirectUri = redirectUri;
        this.state = state;
        this.timestamp = Instant.now(clock).toEpochMilli();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public String toString() {
        return "OAuthTokenResponse [accessToken=" + this.accessToken + ", tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ", scope=" + this.scope + ", refreshToken=" + this.refreshToken + ", idToken=" + this.idToken + "]";
    }
}

