/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.Collections;
import java.util.Map;
import org.clazzes.util.sec.OAuthCredentials;

public class OAuthRobotCredentials
implements OAuthCredentials {
    private final String bearerToken;
    private final Map<String, String> additionalAttributes;
    private final long refreshMillis;

    public OAuthRobotCredentials(String bearerToken, Map<String, String> additionalAttributes, long refreshMillis) {
        this.bearerToken = bearerToken;
        this.additionalAttributes = additionalAttributes;
        this.refreshMillis = refreshMillis;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public Map<String, String> getAdditionalAttributes() {
        if (this.additionalAttributes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.additionalAttributes);
    }

    public String getAdditionalAttribute(String key) {
        if (this.additionalAttributes == null) {
            return null;
        }
        return this.additionalAttributes.get(key);
    }

    public long getRefreshMillis() {
        return this.refreshMillis;
    }

    public String toString() {
        return "OAuthRobotCredentials [bearerToken=" + this.bearerToken + ", additionalAttributes=" + String.valueOf(this.additionalAttributes) + ", refreshMillis=" + this.refreshMillis + "]";
    }
}

