/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.login.jbo.jwt.JWToken;
import org.clazzes.login.oauth.OAuthGroup;
import org.clazzes.util.sec.DomainPrincipal;
import org.clazzes.util.sec.OAuthCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthPrincipal
implements DomainPrincipal,
OAuthCredentials {
    private static final Logger log = LoggerFactory.getLogger(OAuthPrincipal.class);
    private static final String GROUPS_CLAIM = "groups";
    private static final String RESOURCE_ACCESS_CLAIM = "resource_access";
    private static final String RESOURCE_ROLES = "roles";
    private final String domain;
    private final String userName;
    private final String prettyName;
    private final String email;
    private final JWToken idToken;
    private final Map<String, String> additionalAttributes;
    private final String bearerToken;
    private final List<OAuthGroup> groups;

    private static String getAttribute(String fallback, Map<String, Object> attributes, String ... names) {
        for (String name : names) {
            Object ret = attributes.get(name);
            if (ret == null) continue;
            return ret.toString();
        }
        return fallback;
    }

    private static Map<String, String> getAdditionalAttribute(Map<String, Object> attributes) {
        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (GROUPS_CLAIM.equals(e.getKey()) || e.getValue() == null) continue;
            additionalAttributes.put(e.getKey(), e.getValue().toString());
        }
        return additionalAttributes;
    }

    private static List<OAuthGroup> getGroups(String domain, Map<String, Object> attributes, String groupRoleResource) {
        if (groupRoleResource == null) {
            Object groups_o = attributes.get(GROUPS_CLAIM);
            if (groups_o instanceof List) {
                List groups = (List)groups_o;
                ArrayList<OAuthGroup> ret = new ArrayList<OAuthGroup>(groups.size());
                for (String group : groups) {
                    ret.add(new OAuthGroup(domain, group));
                }
                return ret;
            }
            if (groups_o instanceof String) {
                return Collections.singletonList(new OAuthGroup(domain, groups_o.toString()));
            }
            return null;
        }
        Object ra = attributes.get(RESOURCE_ACCESS_CLAIM);
        if (log.isDebugEnabled()) {
            log.debug("ra=[{}]", ra);
        }
        if (ra instanceof Map) {
            Map ra_map = (Map)ra;
            Object ac = ra_map.get(groupRoleResource);
            if (log.isDebugEnabled()) {
                log.debug("ac=[{}]", ac);
            }
            if (ac instanceof Map) {
                Map ac_map = (Map)ac;
                Object roles_o = ac_map.get(RESOURCE_ROLES);
                if (log.isDebugEnabled()) {
                    log.debug("roles_o=[{}]", roles_o);
                }
                if (roles_o instanceof List) {
                    List roles = (List)roles_o;
                    ArrayList<OAuthGroup> ret = new ArrayList<OAuthGroup>(roles.size());
                    for (String group : roles) {
                        ret.add(new OAuthGroup(domain, group));
                    }
                    return ret;
                }
            }
        }
        return null;
    }

    public OAuthPrincipal(String domain, Map<String, Object> attributes, String bearerToken, String groupRoleResource) {
        this.domain = domain;
        this.additionalAttributes = OAuthPrincipal.getAdditionalAttribute(attributes);
        this.groups = OAuthPrincipal.getGroups(domain, attributes, groupRoleResource);
        this.userName = OAuthPrincipal.getAttribute(null, attributes, "preferred_username", "login", "upn", "email");
        this.email = OAuthPrincipal.getAttribute(null, attributes, "email");
        this.prettyName = OAuthPrincipal.getAttribute(null, attributes, "name", "preferred_username", "login", "email", "upn");
        this.bearerToken = bearerToken;
        this.idToken = null;
    }

    public OAuthPrincipal(String domain, JWToken idToken, String bearerToken, String groupRoleResource) {
        this.domain = domain;
        Map attributes = idToken.getClaimSet().getAdditionalClaims();
        this.additionalAttributes = OAuthPrincipal.getAdditionalAttribute(attributes);
        this.groups = OAuthPrincipal.getGroups(domain, attributes, groupRoleResource);
        this.userName = OAuthPrincipal.getAttribute(idToken.getClaimSet().getSubject(), attributes, "preferred_username", "login", "upn", "email");
        this.email = OAuthPrincipal.getAttribute(null, attributes, "email");
        this.prettyName = OAuthPrincipal.getAttribute(null, attributes, "name", "preferred_username", "login", "email", "upn");
        this.bearerToken = bearerToken;
        this.idToken = idToken;
    }

    public String getName() {
        return this.domain + "/" + this.userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEMailAddress() {
        return this.email;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public JWToken getIdToken() {
        return this.idToken;
    }

    public List<OAuthGroup> getGroups() {
        return this.groups;
    }

    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public String getAdditionalAttribute(String key) {
        if (this.additionalAttributes == null) {
            return null;
        }
        return this.additionalAttributes.get(key);
    }

    public String toString() {
        return "OAuthPrincipal [domain=" + this.domain + ", userName=" + this.userName + ", groups=" + String.valueOf(this.groups) + ", additionalAttributes=" + String.valueOf(this.additionalAttributes) + "]";
    }
}

