/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.login.oauth.AuthState;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.DomainConfig;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.LoginInfo;
import org.clazzes.login.oauth.OAuthAbstrServlet;
import org.clazzes.login.oauth.OAuthGroup;
import org.clazzes.login.oauth.OAuthPrincipal;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.i18n.OAuthMessages;
import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.http.LocaleHelper;
import org.clazzes.util.http.RequestHelper;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthLoginServlet
extends OAuthAbstrServlet {
    private static final long serialVersionUID = 6376913713678650071L;
    private static final Logger log = LoggerFactory.getLogger(OAuthLoginServlet.class);
    private String alternativeLabel;
    private String alternativeIconLocation;

    protected void writeLoginForm(Messages i18n, HttpServletResponse resp, String css, List<String> domainsToSelect, String state, String selectedDomain, String user, String groups, OAuthTokenResponse tokens, OAuthTokenErrorResponse error) throws IOException, ServletException {
        try {
            Object script;
            int status = user != null ? 200 : (error != null ? 403 : 401);
            String lang = LocaleHelper.toXsLanguage((Locale)i18n.getLocale());
            resp.setHeader("X-Frame-Options", "SAMEORIGIN");
            resp.setHeader("Content-Language", lang);
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("application/xhtml+xml");
            resp.getOutputStream().write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n".getBytes("UTF-8"));
            XMLStreamWriter xsw = xmlOutputFactory.createXMLStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
            xsw.setDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeAttribute("lang", lang);
            xsw.writeAttribute("xml:lang", lang);
            xsw.writeStartElement("head");
            xsw.writeEmptyElement("meta");
            xsw.writeAttribute("http-equiv", "Content-Type");
            xsw.writeAttribute("content", "application/xhtml+xml");
            xsw.writeEmptyElement("link");
            xsw.writeAttribute("type", "text/css");
            xsw.writeAttribute("rel", "stylesheet");
            xsw.writeAttribute("href", css == null ? "oauth-login.css" : css);
            if (domainsToSelect == null && status == 401) {
                xsw.writeStartElement("script");
                script = new StringBuffer();
                ((StringBuffer)script).append("\nsetTimeout(function() {\n");
                ((StringBuffer)script).append("  var loc = window.location.href;\n");
                ((StringBuffer)script).append("  var r = loc.match(/&n=([0-9]+)/);\n");
                ((StringBuffer)script).append("  if (r == null) {\n");
                ((StringBuffer)script).append("    loc += '&n=1';\n");
                ((StringBuffer)script).append("  }\n");
                ((StringBuffer)script).append("  else {\n");
                ((StringBuffer)script).append("    var n = Number(r[1])+1;\n");
                ((StringBuffer)script).append("    loc = loc.replace(/&n=[0-9]+/,'&n='+n);\n");
                ((StringBuffer)script).append("  }\n");
                ((StringBuffer)script).append("  window.location.href = loc;\n");
                ((StringBuffer)script).append("},100);\n");
                xsw.writeCData(((StringBuffer)script).toString());
                xsw.writeEndElement();
            }
            if (domainsToSelect != null) {
                xsw.writeStartElement("script");
                script = new StringBuffer();
                ((StringBuffer)script).append("\nfunction openDomain(domain) {\n");
                ((StringBuffer)script).append("  window.open('/oauth-login/start?locale=");
                ((StringBuffer)script).append(lang);
                ((StringBuffer)script).append("&domain='+domain+'&state=");
                ((StringBuffer)script).append(state);
                ((StringBuffer)script).append("');\n");
                ((StringBuffer)script).append("  var loc = window.location.href;\n");
                ((StringBuffer)script).append("  loc += loc.indexOf('?')>=0 ? '&' : '?';\n");
                ((StringBuffer)script).append("  loc += 'state=';\n");
                ((StringBuffer)script).append("  loc += '");
                ((StringBuffer)script).append(state);
                ((StringBuffer)script).append("';\n");
                ((StringBuffer)script).append("  window.location.href = loc;\n");
                ((StringBuffer)script).append("}\n");
                xsw.writeCData(((StringBuffer)script).toString());
                xsw.writeEndElement();
            }
            if (status == 200 && tokens != null && tokens.getAccessToken() != null) {
                xsw.writeStartElement("script");
                script = new StringBuffer();
                ((StringBuffer)script).append("\nasync function writeAccessToken(pfx,usage) {\n");
                ((StringBuffer)script).append("  try {\n");
                ((StringBuffer)script).append("    await navigator.clipboard.writeText(pfx+'\"");
                ((StringBuffer)script).append(tokens.getAccessToken());
                ((StringBuffer)script).append("\"');\n");
                ((StringBuffer)script).append("    document.getElementById('http-login-access-feedback').innerText='Token copied to clipboard.';");
                ((StringBuffer)script).append("    document.getElementById('http-login-access-usage').innerText=usage;");
                ((StringBuffer)script).append("  } catch (error) {\n");
                ((StringBuffer)script).append("    console.log('Copying token failed',error);\n");
                ((StringBuffer)script).append("    document.getElementById('http-login-access-feedback').innerText='Copying token failed: '+error.messages;\n");
                ((StringBuffer)script).append("    document.getElementById('http-login-access-usage').innerText='';");
                ((StringBuffer)script).append("  }\n");
                ((StringBuffer)script).append("}\n");
                xsw.writeCData(((StringBuffer)script).toString());
                xsw.writeEndElement();
            }
            xsw.writeStartElement("title");
            xsw.writeCharacters("OAuth Single-Sign-On");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            xsw.writeStartElement("form");
            xsw.writeAttribute("id", "loginResultForm");
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "status");
            xsw.writeAttribute("value", String.valueOf(status));
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "principal");
            xsw.writeAttribute("value", user == null ? "" : user);
            xsw.writeEndElement();
            if (status == 200) {
                xsw.writeStartElement("p");
                if (groups == null) {
                    xsw.writeCharacters(i18n.formatString("logged-in-as-ok", new Object[]{user}));
                } else {
                    xsw.writeCharacters(i18n.formatString("logged-in-as-ok-with-groups", new Object[]{user, groups}));
                }
                xsw.writeEndElement();
                if (tokens != null && tokens.getAccessToken() != null) {
                    xsw.writeStartElement("p");
                    xsw.writeCharacters("Copy access token: ");
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", "javascript:writeAccessToken('TOKEN=','curl -H \"Authorization: Bearer \" -H \"Accept: application/json\" https://host/path')");
                    xsw.writeAttribute("class", "http-login-action");
                    xsw.writeCharacters("unix");
                    xsw.writeEndElement();
                    xsw.writeCharacters(" ");
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", "javascript:writeAccessToken(' = ','Invoke-WebRequest -Headers  @{ Authorization=\"Bearer \"; Accept=\"application/json\" } -Uri https://host/path')");
                    xsw.writeAttribute("class", "http-login-action");
                    xsw.writeCharacters("ps1");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeStartElement("p");
                    xsw.writeAttribute("id", "http-login-access-feedback");
                    xsw.writeEndElement();
                    xsw.writeStartElement("p");
                    xsw.writeAttribute("id", "http-login-access-usage");
                    xsw.writeEndElement();
                }
                xsw.writeStartElement("p");
                xsw.writeStartElement("a");
                xsw.writeAttribute("href", this.oauthHttpLoginService.getLoginUrl() + "?logout=true&locale=" + lang);
                xsw.writeAttribute("class", "http-login-action");
                xsw.writeCharacters(i18n.getString("do-logout"));
                xsw.writeEndElement();
                xsw.writeEndElement();
            } else if (domainsToSelect != null) {
                xsw.writeStartElement("div");
                xsw.writeAttribute("class", "http-login-Domain");
                xsw.writeCharacters(i18n.getString("select-domain"));
                xsw.writeEndElement();
                for (String domain : domainsToSelect) {
                    DomainManager dm = this.configurationService.getDomainManager(domain);
                    DomainConfig dc = dm.getDomainConfig();
                    URI favicon = dc.getFaviconLocation();
                    xsw.writeStartElement("div");
                    xsw.writeAttribute("class", "http-login-Domain");
                    if (favicon != null) {
                        xsw.writeStartElement("img");
                        xsw.writeAttribute("width", "16");
                        xsw.writeAttribute("height", "16");
                        xsw.writeAttribute("src", favicon.toString());
                        xsw.writeEndElement();
                    }
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", "javascript:openDomain('" + domain + "')");
                    xsw.writeAttribute("class", "http-login-action");
                    xsw.writeCharacters(dc.getLabel());
                    xsw.writeEndElement();
                    if (dc.getOptions().contains((Object)ConfigOptions.renderUserLogout)) {
                        try {
                            URI logoutUri = dm.getOpenIdLocation("end_session_endpoint");
                            xsw.writeStartElement("a");
                            xsw.writeAttribute("href", logoutUri.toString());
                            xsw.writeAttribute("target", "_blank");
                            xsw.writeAttribute("class", "http-login-Logout");
                            xsw.writeAttribute("title", i18n.formatString("logout-from-target-domain", new Object[]{domain}));
                            xsw.writeEndElement();
                        }
                        catch (IllegalStateException | URISyntaxException e) {
                            log.warn("Unable to render logout URI for domain [" + domain + "]", (Throwable)e);
                        }
                    }
                    xsw.writeEmptyElement("br");
                    xsw.writeEndElement();
                }
                HttpLoginService alternativeService = this.oauthHttpLoginService.getAlternativeService();
                if (alternativeService != null) {
                    String href = alternativeService.getLoginUrl();
                    href = UrlHelper.appendQueryParameterToUrl((String)href, (String)"oauth", (String)"true");
                    href = UrlHelper.appendQueryParameterToUrl((String)href, (String)"locale", (String)lang);
                    xsw.writeStartElement("div");
                    xsw.writeAttribute("class", "http-login-Domain");
                    if (this.alternativeIconLocation != null && !this.alternativeIconLocation.isBlank()) {
                        xsw.writeStartElement("img");
                        xsw.writeAttribute("width", "16");
                        xsw.writeAttribute("height", "16");
                        xsw.writeAttribute("src", this.alternativeIconLocation);
                        xsw.writeEndElement();
                    }
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", href);
                    xsw.writeAttribute("class", "http-login-action");
                    if (this.alternativeLabel != null && !this.alternativeLabel.isBlank()) {
                        xsw.writeCharacters(this.alternativeLabel);
                    } else {
                        xsw.writeCharacters(i18n.getString("alternative-login"));
                    }
                    xsw.writeEndElement();
                    xsw.writeEmptyElement("br");
                    xsw.writeEndElement();
                }
            } else if (error != null) {
                xsw.writeCharacters(i18n.formatString("authentication-failed", new Object[]{selectedDomain}));
                xsw.writeStartElement("p");
                xsw.writeCharacters(error.getError());
                if (error.getErrorDescription() != null) {
                    xsw.writeEmptyElement("br");
                    xsw.writeCharacters(error.getErrorDescription());
                }
                xsw.writeEndElement();
                xsw.writeStartElement("a");
                xsw.writeAttribute("href", this.oauthHttpLoginService.getLoginUrl());
                xsw.writeAttribute("class", "http-login-action");
                xsw.writeCharacters(i18n.getString("do-retry"));
                xsw.writeEndElement();
            } else {
                xsw.writeStartElement("p");
                xsw.writeCharacters(i18n.formatString("authentication-running", new Object[]{selectedDomain}));
                xsw.writeEndElement();
                xsw.writeStartElement("p");
                xsw.writeStartElement("a");
                xsw.writeAttribute("href", this.oauthHttpLoginService.getLoginUrl() + "?logout=true&locale=" + lang + "&state=" + state);
                xsw.writeAttribute("class", "http-login-action");
                xsw.writeCharacters(i18n.getString("abort-authentication"));
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.close();
            resp.flushBuffer();
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error setting XML stream writer", (Throwable)e);
        }
    }

    protected static String makeGroupString(OAuthPrincipal principal) {
        List<OAuthGroup> groups = principal.getGroups();
        String groupString = null;
        if (groups != null) {
            groupString = groups.stream().map(x -> x.getName()).collect(Collectors.joining(","));
        }
        if (log.isDebugEnabled()) {
            log.debug("groupString=[{}]", groupString);
        }
        return groupString;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI requestURI;
        String state = req.getParameter("state");
        String css = req.getParameter("css");
        Locale locale = OAuthLoginServlet.getRequestLocale(req);
        Messages i18n = OAuthMessages.getMesssages(locale);
        String pi = req.getPathInfo();
        try {
            requestURI = RequestHelper.getOriginalRequestUri((HttpServletRequest)req);
        }
        catch (URISyntaxException | ParseException e) {
            throw new ServletException("Unable to parse full request URI for request to [" + RequestHelper.getRequestUrl((HttpServletRequest)req) + "]", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Received request to [{}]", (Object)requestURI);
            log.debug("domains=", this.configurationService.getDomains());
        }
        if (pi == null) {
            String logout = req.getParameter("logout");
            if ("true".equals(logout)) {
                this.oauthHttpLoginService.logout(req);
                if (state != null) {
                    this.authStateCache.removeAuthState(state);
                }
                resp.sendRedirect(this.oauthHttpLoginService.getLoginUrl() + "?locale=" + LocaleHelper.toXsLanguage((Locale)locale));
                return;
            }
            LoginInfo loginInfo = this.oauthHttpLoginService.checkLoginInfo(req);
            if (loginInfo != null) {
                OAuthPrincipal principal = loginInfo.getPrincipal();
                String groupString = OAuthLoginServlet.makeGroupString(principal);
                boolean show_tokens = Boolean.TRUE.equals(RequestHelper.getBooleanParameter((HttpServletRequest)req, (String)"tokens"));
                this.writeLoginForm(i18n, resp, css, null, null, principal.getDomain(), principal.getName(), groupString, show_tokens ? loginInfo.getResponse() : null, null);
                return;
            }
            AuthState authState = null;
            if (state != null && (authState = this.authStateCache.getAuthState(state)) == null) {
                log.warn("Received request to [{}] with invalid or expired state parameter.", (Object)requestURI);
                resp.sendRedirect(this.oauthHttpLoginService.getLoginUrl() + "?locale=" + LocaleHelper.toXsLanguage((Locale)locale));
                return;
            }
            if (authState == null) {
                Principal principal;
                HttpLoginService alternativeService = this.oauthHttpLoginService.getAlternativeService();
                if (alternativeService != null && (principal = alternativeService.checkLogin(req)) != null) {
                    resp.sendRedirect(alternativeService.getLoginUrl());
                    return;
                }
                List<String> domains = this.configurationService.getDomains();
                authState = this.authStateCache.createAuthState(locale, 900000L);
                this.writeLoginForm(i18n, resp, css, domains, authState.getState(), null, null, null, null, null);
                return;
            }
            try {
                Integer n = RequestHelper.getIntegerParameter((HttpServletRequest)req, (String)"n");
                long timeout = n == null ? 0L : 30000L;
                OAuthTokenResponse response = authState.waitForResponse(timeout);
                String user = null;
                String groupString = null;
                if (response != null) {
                    log.info("Retrieving logged on principal for request to [{}].", (Object)requestURI);
                    OAuthPrincipal principal = this.oauthHttpLoginService.tryLogin(req, resp, authState.getDomain(), response, i18n);
                    user = principal.getName();
                    groupString = OAuthLoginServlet.makeGroupString(principal);
                    log.info("Successful login of user [{}] upon request to [{}].", (Object)user, (Object)requestURI);
                    this.authStateCache.removeAuthState(state);
                }
                boolean show_tokens = Boolean.TRUE.equals(RequestHelper.getBooleanParameter((HttpServletRequest)req, (String)"tokens"));
                this.writeLoginForm(i18n, resp, css, null, state, authState.getDomain(), user, groupString, show_tokens ? response : null, null);
                return;
            }
            catch (OAuthTokenErrorResponse e) {
                this.writeLoginForm(i18n, resp, css, null, null, authState.getDomain(), null, null, null, e);
                return;
            }
            catch (InterruptedException e) {
                throw new ServletException("Wait for ongoing authorization has been interrupted", (Throwable)e);
            }
        }
        resp.sendError(404);
    }

    public String getServletInfo() {
        return OAuthLoginServlet.class.getSimpleName();
    }

    public void setAlternativeLabel(String alternativeLabel) {
        this.alternativeLabel = alternativeLabel;
    }

    public void setAlternativeIconLocation(String alternativeIconLocation) {
        this.alternativeIconLocation = alternativeIconLocation;
    }
}

