/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.login.oauth.AuthState;
import org.clazzes.login.oauth.DomainConfig;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.OAuthAbstrServlet;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.i18n.OAuthMessages;
import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.http.LocaleHelper;
import org.clazzes.util.http.RequestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthServlet
extends OAuthAbstrServlet {
    private static final long serialVersionUID = 6376913713678650071L;
    private static final Logger log = LoggerFactory.getLogger(OAuthAuthServlet.class);

    protected void renderAuthenticationResult(Messages i18n, HttpServletResponse resp, String css, String domain, String scope, OAuthTokenErrorResponse error) throws IOException, ServletException {
        try {
            String lang = LocaleHelper.toXsLanguage((Locale)i18n.getLocale());
            resp.setHeader("X-Frame-Options", "SAMEORIGIN");
            resp.setHeader("Content-Language", lang);
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=utf-8");
            resp.getOutputStream().write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n".getBytes("UTF-8"));
            XMLStreamWriter xsw = xmlOutputFactory.createXMLStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
            xsw.setDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeAttribute("lang", lang);
            xsw.writeAttribute("xml:lang", lang);
            xsw.writeStartElement("head");
            xsw.writeEmptyElement("meta");
            xsw.writeAttribute("http-equiv", "Content-Type");
            xsw.writeAttribute("content", "text/html; charset=utf-8");
            xsw.writeEmptyElement("link");
            xsw.writeAttribute("type", "text/css");
            xsw.writeAttribute("rel", "stylesheet");
            xsw.writeAttribute("href", css == null ? "oauth-login.css" : css);
            xsw.writeStartElement("script");
            xsw.writeCharacters("\nsetTimeout(window.close,3000);\n");
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            if (scope != null) {
                xsw.writeStartElement("p");
                xsw.writeCharacters(i18n.formatString("authenticated-with-scope", new Object[]{scope}));
                xsw.writeEndElement();
            }
            if (error != null) {
                xsw.writeStartElement("p");
                xsw.writeCharacters(i18n.formatString("authentication-failed", new Object[]{domain}));
                xsw.writeEndElement();
                xsw.writeStartElement("p");
                xsw.writeCharacters(error.getError());
                if (error.getErrorDescription() != null) {
                    xsw.writeEmptyElement("br");
                    xsw.writeCharacters(error.getErrorDescription());
                }
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.close();
            resp.flushBuffer();
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error setting XML stream writer", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI requestURI;
        String state = req.getParameter("state");
        String css = req.getParameter("css");
        String pi = req.getPathInfo();
        try {
            requestURI = RequestHelper.getOriginalRequestUri((HttpServletRequest)req);
        }
        catch (URISyntaxException | ParseException e) {
            throw new ServletException("Unable to parse full request URI for request to [" + RequestHelper.getRequestUrl((HttpServletRequest)req) + "]", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Received request to [{}]", (Object)requestURI);
        }
        if (pi == null) {
            if (state == null) {
                log.info("Received request to [{}] without state parameter.", (Object)requestURI);
                resp.sendError(400);
                return;
            }
            AuthState authState = this.authStateCache.getAuthState(state);
            if (authState == null) {
                log.info("Received request to [{}] with invalid or expired state parameter.", (Object)requestURI);
                resp.sendError(400);
                return;
            }
            Locale locale = authState.getLocale();
            Messages i18n = OAuthMessages.getMesssages(locale);
            String code = req.getParameter("code");
            if (code != null) {
                String domain = authState.getDomain();
                DomainManager domainManager = this.configurationService.getDomainManager(domain);
                DomainConfig domainConfig = domainManager.getDomainConfig();
                URI tokenUri = null;
                try {
                    tokenUri = domainManager.getTokenUri();
                    String scope = domainConfig.getScope();
                    log.info("Requesting token from [{}] upon request to [{}] with valid authentication code.", (Object)tokenUri, (Object)requestURI);
                    URI redirectUri = new URI(requestURI.getScheme(), requestURI.getUserInfo(), requestURI.getHost(), requestURI.getPort(), this.oauthHttpLoginService.getRedirectUrl(), null, requestURI.getFragment());
                    OAuthTokenResponse tokenResponse = this.oauthHttpClient.requestToken(tokenUri, redirectUri.toString(), state, scope, domainConfig.getClientCredentials(), code, domainConfig.getOptions());
                    authState.setResponse(tokenResponse);
                    this.renderAuthenticationResult(i18n, resp, css, authState.getDomain(), tokenResponse.getScope(), null);
                }
                catch (OAuthTokenErrorResponse e) {
                    log.error("Token request to [{}] with authentication code [{}] failed.", (Object)tokenUri, (Object)code);
                    authState.setError(e);
                    this.renderAuthenticationResult(i18n, resp, css, authState.getDomain(), null, e);
                }
                catch (URISyntaxException e) {
                    log.error("Cannot build redirect URI for request to [" + String.valueOf(requestURI) + "].", (Throwable)e);
                    OAuthTokenErrorResponse oauthError = new OAuthTokenErrorResponse("invalid_redirect_uri", "configured redirect URI is malformed", null, null, null, null, null);
                    authState.setError(oauthError);
                    this.renderAuthenticationResult(i18n, resp, css, authState.getDomain(), null, oauthError);
                }
                catch (IllegalStateException e) {
                    log.error("OpenID configuration of domain [" + domainConfig.getDomain() + "] not loaded while requesting token location", (Throwable)e);
                    OAuthTokenErrorResponse oauthError = new OAuthTokenErrorResponse("openid-configuration-not-loaded", i18n);
                    this.renderAuthenticationResult(i18n, resp, css, authState.getDomain(), null, oauthError);
                }
            } else {
                String error = req.getParameter("error");
                if (error != null) {
                    String errorDescription = req.getParameter("error_description");
                    log.info("Received request to [{}] with authentication error.", (Object)requestURI);
                    OAuthTokenErrorResponse oauthError = new OAuthTokenErrorResponse(error, errorDescription, null, null, null, null, null);
                    authState.setError(oauthError);
                    this.renderAuthenticationResult(i18n, resp, css, authState.getDomain(), null, oauthError);
                } else {
                    log.info("Received request to [{}] with neither an authentication code nor an error.", (Object)requestURI);
                    resp.sendError(400);
                }
            }
        } else {
            resp.sendError(404);
        }
    }

    public String getServletInfo() {
        return OAuthAuthServlet.class.getSimpleName();
    }
}

