/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.time.Clock;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.DomainConfig;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.RobotGrantType;
import org.clazzes.login.oauth.impl.JWTokenValidator;
import org.clazzes.login.oauth.impl.OAuthHttpClientImpl;
import org.clazzes.util.sec.OAuthCredentials;

public class NoOsgi {
    private OAuthHttpClientImpl oAuthHttpClient = new OAuthHttpClientImpl();
    private JWTokenValidator tokenValidator = new JWTokenValidator();
    private Clock clock = Clock.systemDefaultZone();

    public void setClock(Clock clock) {
        this.clock = clock;
        this.oAuthHttpClient.setClock(clock);
        this.tokenValidator.setClock(clock);
    }

    public DomainBuilder build(String domain) {
        return new DomainBuilder(domain);
    }

    public class DomainBuilder {
        private final String domain;
        private String label;
        private String scope;
        private String prompt;
        private String accessType;
        private String resource;
        private URI authorizationLocation;
        private URI tokenLocation;
        private URI userLocation;
        private URI configurationLocation;
        private URI faviconLocation;
        private PasswordAuthentication clientCredentials;
        private String groupRoleResource;
        private EnumSet<ConfigOptions> options = EnumSet.noneOf(ConfigOptions.class);
        private Map<String, String> appUsers = new HashMap<String, String>();
        private String robotScope;
        private RobotGrantType robotGrantType = RobotGrantType.client_credentials;
        private PasswordAuthentication robotCredentials;
        private PasswordAuthentication robotUserCredentials;

        private DomainBuilder(String domain) {
            this.domain = domain;
        }

        public DomainBuilder label(String label) {
            this.label = label;
            return this;
        }

        public DomainBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public DomainBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public DomainBuilder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public DomainBuilder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public DomainBuilder authorizationLocation(URI authorizationLocation) {
            this.authorizationLocation = authorizationLocation;
            return this;
        }

        public DomainBuilder tokenLocation(URI tokenLocation) {
            this.tokenLocation = tokenLocation;
            return this;
        }

        public DomainBuilder userLocation(URI userLocation) {
            this.userLocation = userLocation;
            return this;
        }

        public DomainBuilder configurationLocation(URI configurationLocation) {
            this.configurationLocation = configurationLocation;
            return this;
        }

        public DomainBuilder faviconLocation(URI faviconLocation) {
            this.faviconLocation = faviconLocation;
            return this;
        }

        public DomainBuilder clientCredentials(PasswordAuthentication clientCredentials) {
            this.clientCredentials = clientCredentials;
            return this;
        }

        public DomainBuilder clientCredentials(String userName, String password) {
            return this.clientCredentials(new PasswordAuthentication(userName, password.toCharArray()));
        }

        public DomainBuilder groupRoleResource(String groupRoleResource) {
            this.groupRoleResource = groupRoleResource;
            return this;
        }

        public DomainBuilder option(ConfigOptions option) {
            this.options.add(option);
            return this;
        }

        public DomainBuilder appUser(String oAuthAppId, String jaasUser) {
            this.appUsers.put(oAuthAppId, jaasUser);
            return this;
        }

        public DomainBuilder robotScope(String robotScope) {
            this.robotScope = robotScope;
            return this;
        }

        public DomainBuilder robotClientCredentials() {
            this.robotGrantType = RobotGrantType.client_credentials;
            return this;
        }

        public DomainBuilder robotPassword() {
            this.robotGrantType = RobotGrantType.password;
            return this;
        }

        public DomainBuilder robotCredentials(PasswordAuthentication robotCredentials) {
            this.robotCredentials = robotCredentials;
            return this;
        }

        public DomainBuilder robotUserCredentials(PasswordAuthentication robotUserCredentials) {
            if (this.robotGrantType != RobotGrantType.password) {
                throw new IllegalStateException();
            }
            this.robotUserCredentials = robotUserCredentials;
            return this;
        }

        public DomainBuilder robotCredentials(String userName, String password) {
            return this.robotCredentials(new PasswordAuthentication(userName, password.toCharArray()));
        }

        public DomainBuilder robotUserCredentials(String userName, String password) {
            return this.robotUserCredentials(new PasswordAuthentication(userName, password.toCharArray()));
        }

        public Domain build() {
            DomainConfig domainConfig = new DomainConfig(this.domain, this.label, this.authorizationLocation, this.tokenLocation, this.userLocation, this.configurationLocation, this.faviconLocation, this.clientCredentials, this.scope, this.prompt, this.accessType, this.resource, this.groupRoleResource, this.options, this.appUsers, this.robotGrantType, this.robotScope, this.robotCredentials, this.robotUserCredentials);
            DomainManager domainManager = new DomainManager(domainConfig, NoOsgi.this.clock, NoOsgi.this.oAuthHttpClient, NoOsgi.this.tokenValidator);
            return new Domain(domainManager);
        }
    }

    public final class Domain {
        private final DomainManager domainManager;

        private Domain(DomainManager domainManager) {
            this.domainManager = domainManager;
        }

        public Supplier<? extends OAuthCredentials> getCredentialsSupplier() {
            return this.domainManager.getCredentialsSupplier();
        }
    }
}

