/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.clazzes.login.oauth.LoginInfo;
import org.clazzes.login.oauth.OAuthPrincipal;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.TokenGenerator;
import org.clazzes.util.http.LocaleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginInfoCache {
    private static final Logger log = LoggerFactory.getLogger(LoginInfoCache.class);
    private final Map<String, LoginInfo> infosBySessionId = new HashMap<String, LoginInfo>(1024);
    private final Map<String, LoginInfo> infosByBearerToken = new HashMap<String, LoginInfo>(1024);
    private TokenGenerator tokenGenerator;

    public synchronized LoginInfo getLoginInfo(String sessionId) {
        LoginInfo ret = this.infosBySessionId.get(sessionId);
        return ret;
    }

    public synchronized LoginInfo getByBearerToken(String token) {
        LoginInfo ret = this.infosByBearerToken.get(token);
        return ret;
    }

    public synchronized LoginInfo removeLoginInfo(String sessionId) {
        return this.infosBySessionId.remove(sessionId);
    }

    private static Locale getLocale(OAuthPrincipal principal, Locale locale) {
        Locale loc;
        String locale_s = principal.getAdditionalAttribute("locale");
        if (locale_s != null && (loc = LocaleHelper.localeFromXsLanguage((String)locale_s)) != null && !loc.equals(locale)) {
            log.info("Replacing locale [{}] for principal [{}] with [{}] determined from OAuth properties.", new Object[]{locale, principal.getName(), loc});
            return loc;
        }
        return locale;
    }

    private static TimeZone getTimeZone(OAuthPrincipal principal, TimeZone timeZone) {
        TimeZone tz;
        String tz_s = principal.getAdditionalAttribute("zoneinfo");
        if (tz_s != null && (tz = TimeZone.getTimeZone(tz_s)) != null && !tz.equals(timeZone)) {
            log.info("Replacing timezone [{}] for principal [{}] with [{}] determined from OAuth properties.", new Object[]{timeZone, principal.getName(), tz});
            return tz;
        }
        return timeZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginInfo createLoginInfo(OAuthPrincipal principal, OAuthTokenResponse response, Locale locale, TimeZone timeZone, long maxAge, boolean registerBearerToken) {
        LoginInfo ret = null;
        timeZone = LoginInfoCache.getTimeZone(principal, timeZone);
        locale = LoginInfoCache.getLocale(principal, locale);
        int ntry = 0;
        do {
            ++ntry;
            String key = this.tokenGenerator.generateToken();
            ret = new LoginInfo(key, locale, timeZone);
            LoginInfoCache loginInfoCache = this;
            synchronized (loginInfoCache) {
                if (this.infosBySessionId.containsKey(key)) {
                    log.warn("Duplicate session ID generated by SecureRandom for principal [{}] of type [{}].", (Object)principal.getName(), (Object)principal.getClass().getName());
                    ret = null;
                } else {
                    LoginInfo oldInfo;
                    this.infosBySessionId.put(key, ret);
                    if (registerBearerToken && response.getAccessToken() != null && (oldInfo = this.infosByBearerToken.put(response.getAccessToken(), ret)) != null) {
                        log.warn("Removing duplicate session entry [{}] for bearer token.", (Object)oldInfo.getSessionId());
                        this.infosBySessionId.remove(oldInfo.getSessionId());
                    }
                    ret.setCredentials(response, principal);
                }
            }
        } while (ret == null && ntry < 5);
        if (ret == null) {
            throw new SecurityException("[" + ntry + "] duplicate session IDs generated by SecureRandom for principal [" + principal.getName() + "] of type [" + principal.getClass().getName() + "].");
        }
        ret.touch(maxAge);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        long now = System.currentTimeMillis();
        LoginInfoCache loginInfoCache = this;
        synchronized (loginInfoCache) {
            Map.Entry<String, LoginInfo> e;
            if (log.isDebugEnabled()) {
                log.debug("Starting login info garbage collection, number of persisted session IDs is [{}]...", (Object)this.infosBySessionId.size());
            }
            Iterator<Map.Entry<String, LoginInfo>> it = this.infosBySessionId.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                if (e.getValue().getExpires() > now) continue;
                if (log.isWarnEnabled()) {
                    log.warn("Login [{}] expired without prior logout.", (Object)e.getValue().getPrincipalsInfo());
                }
                it.remove();
            }
            it = this.infosByBearerToken.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                if (e.getValue().getExpires() > now) continue;
                if (log.isWarnEnabled()) {
                    log.warn("Bearer Token [{}] for login [{}] expired without prior logout.", (Object)e.getKey(), (Object)e.getValue().getPrincipalsInfo());
                }
                it.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug("Login info garbage collection finished, number of persisted session IDs is [{}].", (Object)this.infosBySessionId.size());
            }
        }
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

