/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigParser {
    private static final Logger log = LoggerFactory.getLogger(JsonConfigParser.class);

    public static final Map<String, Object> parseConfig(InputStream is) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));){
            HashMap<String, Object> ret = new HashMap<String, Object>();
            reader.beginObject();
            block13: while (reader.hasNext()) {
                String name = reader.nextName();
                JsonToken tokenType = reader.peek();
                switch (tokenType) {
                    case NULL: {
                        reader.nextNull();
                        ret.put(name, null);
                        continue block13;
                    }
                    case BOOLEAN: {
                        ret.put(name, reader.nextBoolean());
                        continue block13;
                    }
                    case NUMBER: {
                        ret.put(name, reader.nextDouble());
                        continue block13;
                    }
                    case STRING: {
                        ret.put(name, reader.nextString());
                        continue block13;
                    }
                    case BEGIN_ARRAY: {
                        ArrayList<String> arr = new ArrayList<String>();
                        reader.beginArray();
                        while (reader.hasNext()) {
                            arr.add(reader.nextString());
                        }
                        reader.endArray();
                        ret.put(name, arr);
                        continue block13;
                    }
                    case BEGIN_OBJECT: {
                        HashMap<String, String> map = new HashMap<String, String>();
                        reader.beginObject();
                        while (reader.hasNext()) {
                            String key = reader.nextName();
                            String value = reader.nextString();
                            map.put(key, value);
                        }
                        reader.endObject();
                        ret.put(name, map);
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unsupported configuration member type [" + String.valueOf(tokenType) + "].");
            }
            reader.endObject();
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }

    public static final Map<String, Object> parseStringMap(InputStream is) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));){
            HashMap<String, Object> ret = new HashMap<String, Object>();
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                JsonToken tokenType = reader.peek();
                if (tokenType == JsonToken.NULL) {
                    reader.nextNull();
                    ret.put(name, null);
                    continue;
                }
                if (tokenType == JsonToken.BOOLEAN) {
                    ret.put(name, reader.nextBoolean());
                    continue;
                }
                if (tokenType == JsonToken.NUMBER) {
                    ret.put(name, reader.nextDouble());
                    continue;
                }
                if (tokenType == JsonToken.STRING) {
                    ret.put(name, reader.nextString());
                    continue;
                }
                if (tokenType == JsonToken.BEGIN_ARRAY) {
                    ArrayList<String> arr = new ArrayList<String>();
                    reader.beginArray();
                    while (reader.hasNext()) {
                        arr.add(reader.nextString());
                    }
                    reader.endArray();
                    ret.put(name, arr);
                    continue;
                }
                log.warn("Ignoring unknown property [{}] in string map response.", (Object)name);
                reader.skipValue();
            }
            reader.endObject();
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }

    public static final Map<String, String> parseAppUsers(String appUsers) {
        String[] parts;
        if (appUsers == null) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String part : parts = appUsers.trim().split("\\s*,\\s*")) {
            if (part.isEmpty()) continue;
            String[] appUser = part.split("\\s*:\\s*", 2);
            if (appUser.length != 2) {
                throw new IllegalArgumentException("Invalid app user stanza [" + String.valueOf(appUser) + "] without colon.");
            }
            ret.put(appUser[0], appUser[1]);
        }
        return ret;
    }
}

