/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.clazzes.login.oauth.AuthStateCache;
import org.clazzes.login.oauth.LoginInfoCache;
import org.clazzes.util.sched.ITimedJob;
import org.clazzes.util.sched.impl.OneTimeSchedulerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollector.class);
    private LoginInfoCache loginInfoCache;
    private AuthStateCache authStateCache;
    private OneTimeSchedulerImpl oneTimeScheduler;
    private UUID jobId;

    public void executorServiceBound(ExecutorService executorService) {
        this.oneTimeScheduler = new OneTimeSchedulerImpl();
        this.oneTimeScheduler.setExecutorService(executorService);
        this.oneTimeScheduler.start();
        this.jobId = this.oneTimeScheduler.scheduleJob((Callable)new GCCallable());
        log.info("Starting OAuth login garbage collector with job ID [{}].", (Object)this.jobId);
    }

    public void executorServiceUnbound(ExecutorService executorService) {
        if (this.oneTimeScheduler != null) {
            log.info("Stopping OAuth login garbage collector with job ID [{}].", (Object)this.jobId);
            this.oneTimeScheduler.shutdownNow();
            this.oneTimeScheduler = null;
            this.jobId = null;
        }
    }

    public void setLoginInfoCache(LoginInfoCache loginInfoCache) {
        this.loginInfoCache = loginInfoCache;
    }

    public void setAuthStateCache(AuthStateCache authStateCache) {
        this.authStateCache = authStateCache;
    }

    private class GCCallable
    implements Callable<Void>,
    ITimedJob {
        private GCCallable() {
        }

        public Long getNextExecutionDelay() {
            return 60000L;
        }

        @Override
        public Void call() throws Exception {
            GarbageCollector.this.loginInfoCache.gc();
            GarbageCollector.this.authStateCache.gc();
            return null;
        }
    }
}

