/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.RobotGrantType;

public class DomainConfig {
    private final String domain;
    private final String label;
    private final String scope;
    private final String prompt;
    private final String accessType;
    private final String resource;
    private final String groupRoleResource;
    private final URI authorizationLocation;
    private final URI tokenLocation;
    private final URI userLocation;
    private final URI configurationLocation;
    private final URI faviconLocation;
    private final PasswordAuthentication clientCredentials;
    private final EnumSet<ConfigOptions> options;
    private final Map<String, String> appUsers;
    private final RobotGrantType robotGrantType;
    private final String robotScope;
    private final PasswordAuthentication robotCredentials;
    private final PasswordAuthentication robotUserCredentials;

    public DomainConfig(String domain, String label, URI authorizationLocation, URI tokenLocation, URI userLocation, URI configurationLocation, URI faviconLocation, PasswordAuthentication clientCredentials, String scope, String prompt, String accessType, String resource, String groupRoleResource, EnumSet<ConfigOptions> options, Map<String, String> appUsers, RobotGrantType robotGrantType, String robotScope, PasswordAuthentication robotCredentials, PasswordAuthentication robotUserCredentials) {
        this.domain = domain;
        this.label = label;
        this.authorizationLocation = authorizationLocation;
        this.tokenLocation = tokenLocation;
        this.userLocation = userLocation;
        this.configurationLocation = configurationLocation;
        this.faviconLocation = faviconLocation;
        this.clientCredentials = clientCredentials;
        this.scope = scope;
        this.prompt = prompt;
        this.accessType = accessType;
        this.resource = resource;
        this.groupRoleResource = groupRoleResource;
        this.options = options;
        this.appUsers = appUsers;
        this.robotGrantType = robotGrantType;
        this.robotScope = robotScope;
        this.robotCredentials = robotCredentials;
        this.robotUserCredentials = robotUserCredentials;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLabel() {
        return this.label;
    }

    public String getResource() {
        return this.resource;
    }

    public String getGroupRoleResource() {
        return this.groupRoleResource;
    }

    public URI getAuthorizationLocation() {
        return this.authorizationLocation;
    }

    public URI getTokenLocation() {
        return this.tokenLocation;
    }

    public URI getUserLocation() {
        return this.userLocation;
    }

    public URI getConfigurationLocation() {
        return this.configurationLocation;
    }

    public URI getFaviconLocation() {
        return this.faviconLocation;
    }

    public EnumSet<ConfigOptions> getOptions() {
        return this.options;
    }

    public PasswordAuthentication getClientCredentials() {
        return this.clientCredentials;
    }

    public Map<String, String> getAppUsers() {
        return this.appUsers;
    }

    public RobotGrantType getRobotGrantType() {
        return this.robotGrantType;
    }

    public String getRobotScope() {
        return this.robotScope;
    }

    public PasswordAuthentication getRobotCredentials() {
        return this.robotCredentials;
    }

    public PasswordAuthentication getRobotUserCredentials() {
        return this.robotUserCredentials;
    }

    private static String formatPWAuth(PasswordAuthentication pw) {
        if (pw == null) {
            return null;
        }
        return pw.getUserName() + "/****";
    }

    public String toString() {
        return "DomainConfig [domain=" + this.domain + ", label=" + this.label + ", scope=" + this.scope + ", prompt=" + this.prompt + ", accessType=" + this.accessType + ", resource=" + this.resource + ", groupRoleResource=" + this.groupRoleResource + ", authorizationLocation=" + String.valueOf(this.authorizationLocation) + ", tokenLocation=" + String.valueOf(this.tokenLocation) + ", userLocation=" + String.valueOf(this.userLocation) + ", configurationLocation=" + String.valueOf(this.configurationLocation) + ", faviconLocation=" + String.valueOf(this.faviconLocation) + ", clientCredentials=" + DomainConfig.formatPWAuth(this.clientCredentials) + ", options=" + String.valueOf(this.options) + ", appUsers=" + String.valueOf(this.appUsers) + ", robotGrantType=" + String.valueOf((Object)this.robotGrantType) + ", robotScope=" + this.robotScope + ", robotCredentials=" + DomainConfig.formatPWAuth(this.robotCredentials) + ", robotUserCredentials=" + DomainConfig.formatPWAuth(this.robotUserCredentials) + "]";
    }

    public boolean isRobot() {
        return this.robotGrantType != null && this.robotCredentials != null;
    }
}

