/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.clazzes.login.oauth.AuthState;
import org.clazzes.login.oauth.TokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthStateCache {
    private static final Logger log = LoggerFactory.getLogger(AuthStateCache.class);
    private final Map<String, AuthState> authStates = new HashMap<String, AuthState>(1024);
    private TokenGenerator tokenGenerator;

    public synchronized AuthState getAuthState(String state) {
        AuthState ret = this.authStates.get(state);
        return ret;
    }

    public synchronized AuthState removeAuthState(String state) {
        return this.authStates.remove(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthState createAuthState(Locale locale, long maxAge) {
        AuthState ret = null;
        int ntry = 0;
        do {
            ++ntry;
            String key = this.tokenGenerator.generateHexState();
            AuthStateCache authStateCache = this;
            synchronized (authStateCache) {
                if (this.authStates.containsKey(key)) {
                    log.warn("Duplicate auth state generated by SecureRandom .");
                    ret = null;
                } else {
                    ret = new AuthState(key, System.currentTimeMillis() + maxAge, locale);
                    this.authStates.put(key, ret);
                }
            }
        } while (ret == null && ntry < 5);
        if (ret == null) {
            throw new SecurityException("[" + ntry + "] auth states generated by SecureRandom.");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        long now = System.currentTimeMillis();
        AuthStateCache authStateCache = this;
        synchronized (authStateCache) {
            if (log.isDebugEnabled()) {
                log.debug("Starting auth state garbage collection, number of persisted states is [{}]...", (Object)this.authStates.size());
            }
            Iterator<Map.Entry<String, AuthState>> it = this.authStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, AuthState> e = it.next();
                if (e.getValue().getExpires() > now) continue;
                if (log.isWarnEnabled()) {
                    log.warn("auth state [{}] expired without prior logout.", (Object)e.getValue().getState());
                }
                it.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug("Login info garbage collection finished, number of persisted states is [{}].", (Object)this.authStates.size());
            }
        }
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

