/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import java.util.Locale;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;

public class AuthState {
    private final String state;
    private final Locale locale;
    private String domain;
    private long expires;
    private OAuthTokenErrorResponse error;
    private OAuthTokenResponse response;

    public AuthState(String state, long expires, Locale locale) {
        this.state = state;
        this.domain = null;
        this.expires = expires;
        this.locale = locale;
    }

    public synchronized void init(String domain1, long expires1) {
        if (this.domain != null) {
            throw new IllegalStateException("Cannot select domain twice.");
        }
        this.domain = domain1;
        this.expires = expires1;
    }

    public String getState() {
        return this.state;
    }

    public synchronized String getDomain() {
        return this.domain;
    }

    public synchronized long getExpires() {
        return this.expires;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void checkState() {
        if (this.response != null || this.error != null) {
            throw new IllegalStateException("Cannot commit state twice.");
        }
    }

    public synchronized void setError(OAuthTokenErrorResponse error) {
        this.checkState();
        this.error = error;
        this.notifyAll();
    }

    public synchronized void setResponse(OAuthTokenResponse response) {
        this.checkState();
        this.response = response;
        this.notifyAll();
    }

    public synchronized OAuthTokenResponse waitForResponse(long timeout) throws OAuthTokenErrorResponse, InterruptedException {
        if (this.response != null) {
            return this.response;
        }
        if (this.error != null) {
            throw this.error;
        }
        if (timeout > 0L) {
            this.wait(timeout);
            if (this.response != null) {
                return this.response;
            }
            if (this.error != null) {
                throw this.error;
            }
        }
        return null;
    }
}

