/***********************************************************
 *
 * OAuth2 single-sign-on for GWT applications of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 12.08.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

 package org.clazzes.login.oauth;

public enum TokenType {

    /**
     * An opaue access token, which will be passed on to a userinfo endpoint
     * for retrieving the real identity behind a user.
     */
    OPAQUE,
    /**
     * A signed JWT Token, which might be checked against the pulibhed list of
     * public keys of the authority provider.
     */
    JWT
}
