package org.clazzes.login.oauth;

import java.util.Collections;
import java.util.Map;

import org.clazzes.util.sec.OAuthCredentials;

public class OAuthRobotCredentials implements OAuthCredentials{

    private final String bearerToken;
    private final Map<String, String> additionalAttributes;
    private final long refreshMillis;

    public OAuthRobotCredentials(String bearerToken, Map<String, String> additionalAttributes,
                                 long refreshMillis) {
        this.bearerToken = bearerToken;
        this.additionalAttributes = additionalAttributes;
        this.refreshMillis = refreshMillis;
    }

    @Override
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Override
    public Map<String, String> getAdditionalAttributes() {

        if (this.additionalAttributes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.additionalAttributes);
    }

    @Override
    public String getAdditionalAttribute(String key) {

        if (this.additionalAttributes == null) {
            return null;
        }
        return this.additionalAttributes.get(key);
    }

    public long getRefreshMillis() {
        return this.refreshMillis;
    }

    @Override
    public String toString() {
        return "OAuthRobotCredentials [bearerToken=" + this.bearerToken +
               ", additionalAttributes=" + this.additionalAttributes +
               ", refreshMillis=" + this.refreshMillis + "]";
    }

}
