/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.ldap;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.clazzes.login.ldap.GroupInfo;
import org.clazzes.login.ldap.GroupInfoCache;
import org.clazzes.util.lang.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupInfoCacheImpl
implements GroupInfoCache {
    private static final Logger log = LoggerFactory.getLogger(GroupInfoCacheImpl.class);
    private final ConcurrentMap<Pair<String, String>, GroupInfo> cache = new ConcurrentHashMap<Pair<String, String>, GroupInfo>();
    private ScheduledExecutorService executorService;
    private Future<?> future;

    private void cancelFuture() {
        if (this.future != null) {
            log.info("Stopping group info garbage collection.");
            this.future.cancel(true);
            this.future = null;
        }
    }

    public void executorServiceBound(ScheduledExecutorService executorService) {
        this.cancelFuture();
        this.executorService = executorService;
        if (this.executorService != null) {
            long interval = 60L;
            log.info("Starting group info garbage collection to be scheduled each [{}] seconds.", (Object)interval);
            this.future = this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    GroupInfoCacheImpl.this.gc();
                }
            }, interval, interval, TimeUnit.SECONDS);
        }
    }

    public void executorServiceUnbound(ScheduledExecutorService executorService) {
        this.cancelFuture();
        this.executorService = null;
    }

    @Override
    public GroupInfo getGroupInfo(String domain, String user, long expiry) {
        Pair key = new Pair((Object)domain, (Object)user);
        long now = System.currentTimeMillis();
        GroupInfo ret = (GroupInfo)this.cache.get(key);
        if (ret != null && ret.getExpiry() < now) {
            if (log.isDebugEnabled()) {
                log.debug("Group info bucket for [{}/{}] timed out, deleting it.", key.getFirst(), key.getSecond());
            }
            this.cache.remove(key, ret);
            ret = null;
        }
        if (ret == null) {
            ret = this.cache.computeIfAbsent((Pair<String, String>)key, k -> {
                if (log.isDebugEnabled()) {
                    log.debug("Creating new group info bucket for [{}/{}]", k.getFirst(), k.getSecond());
                }
                return new GroupInfo(expiry);
            });
        }
        return ret;
    }

    public void gc() {
        long now = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Starting group info cache garbage collector...");
        }
        ArrayList deleteEntries = new ArrayList();
        for (Map.Entry e : this.cache.entrySet()) {
            if (e.getValue() == null || ((GroupInfo)e.getValue()).getExpiry() >= now) continue;
            deleteEntries.add(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Group info cache garbage collector detected [{}] outdated buckets.", (Object)deleteEntries.size());
        }
        int ndelete = 0;
        for (Map.Entry entry : deleteEntries) {
            Pair k = (Pair)entry.getKey();
            if (!this.cache.remove(k, entry.getValue())) continue;
            if (log.isDebugEnabled()) {
                log.debug("Deleting outdated group info bucket [{}/{}].", k.getFirst(), k.getSecond());
            }
            ++ndelete;
        }
        if (deleteEntries.size() > 0) {
            log.info("Garbage collected [{}/{}] outdated group info cache entries.", (Object)ndelete, (Object)deleteEntries.size());
        }
    }
}

