/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.ldap;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Consumer;
import org.clazzes.login.ldap.DomainConfig;
import org.clazzes.svc.api.ConfigWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements Consumer<ConfigWrapper> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    public static final String CONFIG_PID = "org.clazzes.login.ldap";
    public static final String AUTHMETHOD_BINDADS = "bindAds";
    public static final String AUTHMETHOD_SEARCH_AND_BIND = "searchAndBind";
    private static final String DEFAULT_USER_ATTRIBUTE = "samAccountName";
    private static final String DEFAULT_PRETTYNAME_ATTRIBUTE = "cn";
    private static final String DEFAULT_EMAILADDRESS_ATTRIBUTE = "mail";
    private static final boolean DEFAULT_ALLOW_EMPTY_PASSWORDS = false;
    private static final boolean DEFAULT_ALLOW_GROUPS_FOR_DISABLED = true;
    private static final String DEFAULT_AUTH_MECHANISM = "simple";
    private String defaultDomain = null;
    private final Map<String, DomainConfig> domainControllers = new HashMap<String, DomainConfig>();

    @Override
    public synchronized void accept(ConfigWrapper config) {
        this.defaultDomain = config.getString("defaultDomain");
        this.domainControllers.clear();
        ConfigWrapper domains = config.getSubTree("domain");
        if (domains != null) {
            for (String domain : domains.keySet()) {
                ConfigWrapper dc = domains.getSubTree(domain);
                if (dc == null) {
                    log.warn("LDAP config key [domain.{}] is not a domain subtree.", (Object)domain);
                    continue;
                }
                try {
                    URI uri = new URI(dc.getMandatoryString("controllerUri"));
                    String binduser = dc.getString("bindUser");
                    PasswordAuthentication auth = null;
                    if (binduser != null) {
                        String bindpw = dc.getString("bindPassword");
                        if (log.isDebugEnabled()) {
                            log.debug("Setting bind credentials for domain [{}] to [{}].", (Object)domain, (Object)binduser);
                        }
                        auth = new PasswordAuthentication(binduser, bindpw.toString().toCharArray());
                    }
                    String authMethod = dc.getString("authMethod", AUTHMETHOD_SEARCH_AND_BIND);
                    String userAttribute = dc.getString("userAttribute", DEFAULT_USER_ATTRIBUTE);
                    String groupAttribute = dc.getString("groupAttribute", userAttribute);
                    String prettyNameAttribute = dc.getString("prettyNameAttribute", DEFAULT_PRETTYNAME_ATTRIBUTE);
                    String eMailAddressAttribute = dc.getString("eMailAddressAttribute", DEFAULT_EMAILADDRESS_ATTRIBUTE);
                    String mobileAttribute = dc.getString("mobileAttribute");
                    String tokenIdsAttribute = dc.getString("tokenIdsAttribute");
                    boolean allowEmptyPasswords = dc.getBoolean("allowEmptyPasswords", false);
                    boolean allowGroupsForDisabledUser = dc.getBoolean("allowGroupsForDisabledUser", true);
                    String authMechanism = dc.getString("authMechanism", DEFAULT_AUTH_MECHANISM);
                    String baseDnToUsers = dc.getString("baseDnToUsers", "");
                    String baseDnToGroups = dc.getString("baseDnToGroups", "");
                    long groupCacheSeconds = dc.getLong("groupCacheSeconds", 300L);
                    long groupTimeoutSeconds = dc.getLong("groupTimeoutSeconds", 30L);
                    this.domainControllers.put(domain, new DomainConfig(domain, uri, auth, authMethod, userAttribute, groupAttribute, prettyNameAttribute, eMailAddressAttribute, mobileAttribute, tokenIdsAttribute, allowEmptyPasswords, allowGroupsForDisabledUser, authMechanism, baseDnToUsers, baseDnToGroups, groupCacheSeconds, groupTimeoutSeconds));
                }
                catch (Exception e) {
                    log.error("Unable to configure LDAP domain [" + domain + "]", (Throwable)e);
                }
            }
        }
    }

    public synchronized String getDefaultDomain() {
        return this.defaultDomain;
    }

    public synchronized List<String> getDomains() {
        Vector<String> domains = new Vector<String>(this.domainControllers.size());
        domains.addAll(this.domainControllers.keySet());
        return domains;
    }

    public synchronized void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public synchronized DomainConfig getDomainController(String domain) {
        return this.domainControllers.get(domain);
    }
}

