/**
 * 
 */
package org.clazzes.login.ldap;

import org.clazzes.util.sec.MFAPrincipal;

/**
 * An ADS principal used for multiple factor authentication.
 */
public class MFAAdsPrincipal extends AdsPrincipal implements MFAPrincipal {

    private final String mobileNumber;
    private final String[] knownTokenIds;
    
    public MFAAdsPrincipal(String user,
            String domain,
            String prettyName,
            String eMailAddress,
            String mobileNumber,
            String[] knownTokenIds) {
        super(user, domain, prettyName, eMailAddress);
        this.mobileNumber = mobileNumber;
        this.knownTokenIds = knownTokenIds;
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.MFAPrincipal#getMobileNumber()
     */
    @Override
    public String getMobileNumber() {
        
        return this.mobileNumber;
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.MFAPrincipal#getKnownTokenIds()
     */
    @Override
    public String[] getKnownTokenIds() {
        
        return this.knownTokenIds;
    }

}
