package org.clazzes.login.ldap;

import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.sec.DomainPasswordLoginService;

public class LdapLoginComponent implements Component {

    public static final String CONFIG_PID = "org.clazzes.login.ldap";
    public static final String SERVICE_KEY = "org.clazzes.login.ldap";

    @Override
    public void start(ServiceContext context) throws Exception {

        ConfigurationEngine ce = context.getService(ConfigurationEngine.class).get();
        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();
        ComponentManager componentManager = context.getService(ComponentManager.class).get();

        ConfigurationService cs = new ConfigurationService();
        LdapDomainPasswordLoginService ldps = new LdapDomainPasswordLoginService();

        ldps.setConfigurationService(cs);

        registry.addService(SERVICE_KEY,DomainPasswordLoginService.class,ldps);

        ce.listen(CONFIG_PID,cs);

        // commit here, to be up even without a configured domain.
        componentManager.commit();
    }

    @Override
    public void stop(ServiceContext context) throws Exception {

        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();

        registry.removeService(SERVICE_KEY,DomainPasswordLoginService.class);
    }

}
