/***********************************************************
 * $Id$
 *
 * LDAP single-sign-on for GWT applications of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 12.08.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.ldap;

import java.net.PasswordAuthentication;
import java.net.URI;

import javax.naming.Context;

/**
 * A configuration entry for an ADS domain.
 */
public class DomainConfig {

    private final String domain;
    private final URI controllerUri;
    private final PasswordAuthentication bindCredentials;
    private final String authMethod;
    private final String userAttribute;
    private final String groupAttribute;
    private final String prettyNameAttribute;
    private final String eMailAddressAttribute;
    private final String mobileAttribute;
    private final String tokenIdsAttribute;
    private final boolean allowEmptyPasswords;
    private final String authMechanism;
    private final String baseDnToUsers;
    private final String baseDnToGroups;
    private final boolean isAllowGroupsForDisabledUser;
    private final long groupCacheSeconds;
    private final long groupTimeoutSeconds;

    public DomainConfig(
            String domain,
            URI controller,
            PasswordAuthentication bindCredentials,
            String authMethod,
            String userAttribute,
            String groupAttribute,
            String prettyNameAttribute,
            String eMailAddressAttribute,
            String mobileAttribute,
            String tokenIdsAttribute,
            boolean allowEmptyPasswords,
            boolean isAllowGroupsForDisabledUser,
            String authMechanism,
            String baseDnToUsers,
            String baseDnToGroups,
            long groupCacheSeconds,
            long groupTimeoutSeconds)
    {
        super();
        this.domain = domain;
        this.controllerUri = controller;
        this.bindCredentials = bindCredentials;
        this.authMethod = authMethod;
        this.userAttribute = userAttribute;
        this.groupAttribute = groupAttribute;
        this.prettyNameAttribute = prettyNameAttribute;
        this.eMailAddressAttribute = eMailAddressAttribute;
        this.mobileAttribute = mobileAttribute;
        this.tokenIdsAttribute = tokenIdsAttribute;
        this.allowEmptyPasswords = allowEmptyPasswords;
        this.isAllowGroupsForDisabledUser = isAllowGroupsForDisabledUser;
        this.authMechanism = authMechanism;
        this.baseDnToUsers = baseDnToUsers;
        this.baseDnToGroups = baseDnToGroups;
        this.groupTimeoutSeconds = groupTimeoutSeconds;
        this.groupCacheSeconds = groupCacheSeconds;
    }

    public String getDomain() {
        return this.domain;
    }

    public URI getControllerUri() {
        return this.controllerUri;
    }

    public PasswordAuthentication getBindCredentials() {
        return this.bindCredentials;
    }

    /**
     *
     * @return The authentication method. May be
     *         <code>searchAndBind</code> or <code>bindAds</code>
     */
    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getUserAttribute() {
        return this.userAttribute;
    }

    public String getGroupAttribute() {
        return this.groupAttribute;
    }

    public String getPrettyNameAttribute() {
        return this.prettyNameAttribute;
    }

    public String getEMailAddressAttribute() {
        return this.eMailAddressAttribute;
    }

    public String geteMailAddressAttribute() {
        return this.eMailAddressAttribute;
    }

    public String getMobileAttribute() {
        return this.mobileAttribute;
    }

    public String getTokenIdsAttribute() {
        return this.tokenIdsAttribute;
    }

    public boolean isAllowEmptyPasswords() {
        return this.allowEmptyPasswords;
    }

    public boolean isAllowGroupsForDisabledUser() { return this.isAllowGroupsForDisabledUser; }

    /**
     * @return The authentication mechanism passed as
     *         {@link Context#SECURITY_AUTHENTICATION}
     *         parameter to the initial LDAP context for
     *         non-anonymous bind operations.
     */
    public String getAuthMechanism() {
        return this.authMechanism;
    }

    /**
     * @return Search for the users in the subtree below this DN (relative to the baseDn in the URL).
     *         Defaults to the empty string.
     */
    public String getBaseDnToUsers() {
        return this.baseDnToUsers;
    }

    /**
     * @return Search for the groups in the subtree below this DN (relative to the baseDn in the URL).
     *         Defaults to the empty string.
     */
    public String getBaseDnToGroups() {
        return this.baseDnToGroups;
    }

    /**
     * @return The number of seconds for which group query results are cached.
     */
    public synchronized long getGroupCacheSeconds() {
        return this.groupCacheSeconds;
    }

    public synchronized long getGroupTimeoutSeconds() {
        return this.groupTimeoutSeconds;
    }


}
