/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.ldap;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.List;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.clazzes.login.ldap.AdsGroup;
import org.clazzes.login.ldap.AdsHelper;
import org.clazzes.login.ldap.AdsPrincipal;
import org.clazzes.login.ldap.ConfigurationService;
import org.clazzes.login.ldap.DomainConfig;
import org.clazzes.login.ldap.GroupInfo;
import org.clazzes.login.ldap.GroupInfoCache;
import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapDomainPasswordLoginService
implements DomainPasswordLoginService {
    private static final Logger log = LoggerFactory.getLogger(LdapDomainPasswordLoginService.class);
    private ConfigurationService configurationService;
    private GroupInfoCache groupInfoCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainPrincipal tryLogin(String domain, String username, String password) {
        Context searchCtxt = null;
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            Object dn;
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            DomainConfig domainConfig = this.configurationService.getDomainController(domain);
            if (domainConfig == null) {
                throw new SecurityException("Invalid domain [" + domain + "] specified.");
            }
            if (password.isEmpty() && !domainConfig.isAllowEmptyPasswords()) {
                throw new SecurityException("Domain [" + domain + "] does not allow empty passwords to be specified.");
            }
            URI uri = AdsHelper.resolveServerURI(domainConfig.getControllerUri());
            if (log.isDebugEnabled()) {
                log.debug("Connecting to LDAP server [{}] for domain [{}]...", (Object)uri, (Object)domain);
            }
            AdsPrincipal userPrincipal = null;
            if ("bindAds".equals(domainConfig.getAuthMethod())) {
                dn = username + "@" + domain;
                userPrincipal = new AdsPrincipal(username, domain, username, null);
            } else if ("searchAndBind".equals(domainConfig.getAuthMethod())) {
                NamingEnumeration<SearchResult> searchResults;
                searchCtxt = AdsHelper.connectToADS(uri, domainConfig.getBindCredentials(), domainConfig.getAuthMechanism());
                if (log.isDebugEnabled()) {
                    log.debug("Sucessfully connected to LDAP server [{}] for domain [{}].", (Object)uri, (Object)domain);
                }
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                String filter = "{0}={1}";
                if (log.isDebugEnabled()) {
                    log.debug("Searching [{}={}]...", (Object)domainConfig.getUserAttribute(), (Object)username);
                }
                if (!(searchResults = searchCtxt.search(domainConfig.getBaseDnToUsers(), filter, new Object[]{domainConfig.getUserAttribute(), username}, ctrl)).hasMoreElements()) {
                    throw new SecurityException("User [" + username + "] not found in domain [" + domain + "].");
                }
                SearchResult result = searchResults.next();
                dn = AdsHelper.getAbsoluteDn(uri, domainConfig.getBaseDnToUsers(), result);
                log.info("User [{}] in domain [{}] resolved to DN [{}].", new Object[]{username, domain, dn});
                userPrincipal = AdsHelper.createPrincipal(domainConfig, result);
                searchCtxt.close();
                searchCtxt = null;
            } else {
                throw new SecurityException("Invalid authentication method [" + domainConfig.getAuthMethod() + "] specified.");
            }
            PasswordAuthentication auth = new PasswordAuthentication((String)dn, password.toCharArray());
            if (log.isDebugEnabled()) {
                log.debug("Binding as [{}] to domain [{}]...", dn, (Object)domain);
            }
            searchCtxt = AdsHelper.connectToADS(uri, auth, domainConfig.getAuthMechanism());
            AdsPrincipal adsPrincipal = userPrincipal;
            return adsPrincipal;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception during LDAP authentication", (Throwable)e);
            }
            log.error("Invalid initial login of user [{}] to domain [{}].", (Object)username, (Object)domain);
            DomainPrincipal domainPrincipal = null;
            return domainPrincipal;
        }
        finally {
            if (searchCtxt != null) {
                try {
                    searchCtxt.close();
                }
                catch (NamingException e) {
                    log.warn("Error closing LDAP context", (Throwable)e);
                }
            }
            if (ocl != null) {
                Thread.currentThread().setContextClassLoader(ocl);
            }
        }
    }

    public String getDefaultDomain() {
        return this.configurationService.getDefaultDomain();
    }

    public List<String> getDomains() {
        return this.configurationService.getDomains();
    }

    public void changePassword(String domain, String username, String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public void deactivateUser(String domain, String username, String reason) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainGroup> getGroups(String domain, String userName) {
        Context searchCtxt = null;
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        GroupInfo pendingGroupInfo = null;
        long groupTimeoutSeconds = 30L;
        try {
            Vector<DomainGroup> groups;
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            DomainConfig domainConfig = this.getCorrectDomainConfig(domain);
            long groupCacheSeconds = domainConfig.getGroupCacheSeconds();
            groupTimeoutSeconds = domainConfig.getGroupTimeoutSeconds();
            long now = System.currentTimeMillis();
            if (groupCacheSeconds > 0L) {
                GroupInfo groupInfo = this.groupInfoCache.getGroupInfo(domain, userName, now + 1000L * groupCacheSeconds);
                List<DomainGroup> groups2 = groupInfo.waitForResult(groupTimeoutSeconds * 1000L);
                if (groups2 != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Returning cached groups [{}] for user [{}/{}].", new Object[]{groups2, domain, userName});
                    }
                    List<DomainGroup> list = groups2;
                    return list;
                }
                pendingGroupInfo = groupInfo;
            }
            URI uri = AdsHelper.resolveServerURI(domainConfig.getControllerUri());
            searchCtxt = AdsHelper.connectToADS(uri, domainConfig.getBindCredentials(), domainConfig.getAuthMechanism());
            if (log.isDebugEnabled()) {
                log.debug("Sucessfully connected to LDAP server [{}] for domain [{}].", (Object)uri, (Object)domain);
            }
            if (log.isDebugEnabled()) {
                log.debug("Searching [{}={}]...", (Object)domainConfig.getUserAttribute(), (Object)userName);
            }
            SearchResult result = this.searchForUser(domain, userName, (LdapContext)searchCtxt, domainConfig);
            String userDn = AdsHelper.getAbsoluteDn(uri, domainConfig.getBaseDnToUsers(), result);
            log.info("User [{}] found in domain [{}] resolved to DN [{}].", new Object[]{userName, domain, userDn});
            Attributes userAttributes = result.getAttributes();
            if (userAttributes == null) {
                log.warn("Search result with DN [" + userDn + "] has no attributes");
                groups = new Vector();
            } else {
                if (!domainConfig.isAllowGroupsForDisabledUser() && AdsHelper.isDisabledAdUser(userAttributes)) {
                    throw new SecurityException("User account " + domain + "\\" + userName + " was disabled.");
                }
                Vector<String> groupDns = this.getMemberOfDns(userAttributes);
                groups = this.getDomainGroups((LdapContext)searchCtxt, domainConfig, uri, groupDns);
            }
            if (pendingGroupInfo != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Caching groups [{}] for user [{}/{}].", new Object[]{groups, domain, userName});
                }
                pendingGroupInfo.setResult(groups);
            }
            if (log.isDebugEnabled()) {
                log.debug("Returning groups [{}] for user [{}/{}].", new Object[]{groups, domain, userName});
            }
            Vector<DomainGroup> vector = groups;
            return vector;
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception during LDAP authentication", e);
            }
            if (pendingGroupInfo != null) {
                long now = System.currentTimeMillis();
                pendingGroupInfo.setError(e.getMessage(), now + groupTimeoutSeconds * 1000L * 2L);
            }
            log.error("Error querying groups of user [" + domain + "/" + userName + "].", e);
            List<DomainGroup> list = null;
            return list;
        }
        finally {
            if (searchCtxt != null) {
                try {
                    searchCtxt.close();
                }
                catch (NamingException e) {
                    log.warn("Error closing LDAP context", (Throwable)e);
                }
            }
            if (ocl != null) {
                Thread.currentThread().setContextClassLoader(ocl);
            }
        }
    }

    private SearchResult searchForUser(String domain, String userName, LdapContext searchCtxt, DomainConfig domainConfig) throws NamingException {
        String filter = "{0}={1}";
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        NamingEnumeration<SearchResult> searchResults = searchCtxt.search(domainConfig.getBaseDnToUsers(), filter, new Object[]{domainConfig.getUserAttribute(), userName}, ctrl);
        if (!searchResults.hasMoreElements()) {
            throw new SecurityException("User [" + userName + "] not found in domain [" + domain + "].");
        }
        SearchResult result = searchResults.next();
        return result;
    }

    private Vector<String> getMemberOfDns(Attributes userAttributes) throws NamingException {
        Vector<String> groupDns = new Vector<String>();
        Attribute memberOfAttribute = userAttributes.get("memberOf");
        if (memberOfAttribute != null) {
            NamingEnumeration<?> memberOfAttributes = memberOfAttribute.getAll();
            while (memberOfAttributes.hasMoreElements()) {
                String groupDn = memberOfAttributes.nextElement().toString();
                if (log.isTraceEnabled()) {
                    String groupName = this.getGroupNameOffCn(groupDn);
                    log.trace("Found memberOf element with groupDn [" + groupDn + "] and CN [" + groupName + "]");
                }
                groupDns.add(groupDn);
            }
        }
        return groupDns;
    }

    private Vector<DomainGroup> getDomainGroups(LdapContext searchCtxt, DomainConfig domainConfig, URI uri, Vector<String> groupDns) throws NamingException {
        Vector<DomainGroup> userGroups = new Vector<DomainGroup>();
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        if (groupDns.size() > 0) {
            for (String groupDn : groupDns) {
                SearchResult groupResult;
                String groupFilter = "distinguishedName={0}";
                if (log.isDebugEnabled()) {
                    log.debug("Searching [{}] with args {}", new Object[]{groupFilter, groupDn});
                }
                String relativeDn = AdsHelper.getRelativeDn(uri, "", groupDn);
                NamingEnumeration<SearchResult> groupResults = searchCtxt.search(relativeDn, groupFilter, new Object[]{groupDn}, ctrl);
                while (groupResults.hasMoreElements() && (groupResult = groupResults.next()) != null) {
                    AdsGroup adsGroup = AdsHelper.createGroup(domainConfig, groupResult);
                    if (log.isTraceEnabled()) {
                        log.trace("Found group object: [{}]", (Object)adsGroup.toString());
                    }
                    userGroups.add(adsGroup);
                }
            }
            this.debugLogFoundGroups(userGroups);
        }
        return userGroups;
    }

    private void debugLogFoundGroups(Vector<DomainGroup> userGroups) {
        if (log.isDebugEnabled()) {
            StringBuilder groupNames = new StringBuilder();
            for (DomainGroup group : userGroups) {
                if (groupNames.length() != 0) {
                    groupNames.append(", ");
                }
                groupNames.append(group.getDomain()).append("\\").append(group.getGroupName());
            }
            log.debug("Found user groups: [" + String.valueOf(groupNames) + "]");
        }
    }

    private String getGroupNameOffCn(String groupDn) throws InvalidNameException {
        LdapName groupDnName = new LdapName(groupDn);
        for (Rdn rdn : groupDnName.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            Object cnValue = rdn.getValue();
            if (cnValue == null) {
                return null;
            }
            return cnValue.toString();
        }
        return null;
    }

    private DomainConfig getCorrectDomainConfig(String domain) {
        DomainConfig domainConfig = this.configurationService.getDomainController(domain);
        if (domainConfig == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        if (domainConfig.getBindCredentials() == null || domainConfig.getBindCredentials().getUserName() == null || domainConfig.getBindCredentials().getUserName().length() == 0) {
            throw new SecurityException("Domain [" + domain + "] has no bind dn.");
        }
        return domainConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainPrincipal> getGroupMembers(String domain, String groupName) {
        Context searchCtxt = null;
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            SearchResult memberResult;
            NamingEnumeration<SearchResult> groupSearchResults;
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            DomainConfig domainConfig = this.getCorrectDomainConfig(domain);
            URI uri = AdsHelper.resolveServerURI(domainConfig.getControllerUri());
            searchCtxt = AdsHelper.connectToADS(uri, domainConfig.getBindCredentials(), domainConfig.getAuthMechanism());
            if (log.isDebugEnabled()) {
                log.debug("Sucessfully connected to LDAP server [{}] for domain [{}].", (Object)uri, (Object)domain);
            }
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            String groupFilter = "{0}={1}";
            if (log.isDebugEnabled()) {
                log.debug("Searching group [{}] in domain [{}]", new Object[]{groupName, domain});
            }
            if (!(groupSearchResults = searchCtxt.search(domainConfig.getBaseDnToGroups(), groupFilter, new Object[]{domainConfig.getGroupAttribute(), groupName}, ctrl)).hasMoreElements()) {
                throw new SecurityException("Group [" + groupName + "] not found in domain [" + domain + "].");
            }
            SearchResult groupResult = groupSearchResults.next();
            String groupDN = AdsHelper.getAbsoluteDn(uri, domainConfig.getBaseDnToGroups(), groupResult);
            log.debug("Group [" + groupName + "] has full DN [" + groupDN + "].");
            String memberFilter = "memberOf={0}";
            if (log.isDebugEnabled()) {
                log.debug("Searching [{}] with args {}", new Object[]{memberFilter, groupDN});
            }
            NamingEnumeration<SearchResult> searchResults = searchCtxt.search(domainConfig.getBaseDnToUsers(), memberFilter, new Object[]{groupDN}, ctrl);
            Vector<DomainPrincipal> memberPrincipals = new Vector<DomainPrincipal>();
            while (searchResults.hasMoreElements() && (memberResult = searchResults.next()) != null) {
                AdsPrincipal memberPrincipal = AdsHelper.createPrincipal(domainConfig, memberResult);
                log.debug("Found group member: [{}]", (Object)memberPrincipal.toString());
                memberPrincipals.add(memberPrincipal);
            }
            if (memberPrincipals.size() == 0) {
                log.warn("Group [" + groupName + "] found in domain [" + domain + "] does not exist or has no members.");
            } else {
                log.debug("Group [" + groupName + "] found in domain [" + domain + "] has " + memberPrincipals.size() + " members.");
            }
            searchCtxt.close();
            searchCtxt = null;
            Vector<DomainPrincipal> vector = memberPrincipals;
            return vector;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception during LDAP authentication", (Throwable)e);
            }
            List<DomainPrincipal> list = null;
            return list;
        }
        finally {
            if (searchCtxt != null) {
                try {
                    searchCtxt.close();
                }
                catch (NamingException e) {
                    log.warn("Error closing LDAP context", (Throwable)e);
                }
            }
            if (ocl != null) {
                Thread.currentThread().setContextClassLoader(ocl);
            }
        }
    }

    public int getSupportedFeatures(String domain) {
        return 52;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainPrincipal searchUser(String domain, String userName) {
        Context searchCtxt = null;
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<SearchResult> searchResults;
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            DomainConfig domainConfig = this.getCorrectDomainConfig(domain);
            URI uri = AdsHelper.resolveServerURI(domainConfig.getControllerUri());
            searchCtxt = AdsHelper.connectToADS(uri, domainConfig.getBindCredentials(), domainConfig.getAuthMechanism());
            if (log.isDebugEnabled()) {
                log.debug("Sucessfully connected to LDAP server [{}] for domain [{}].", (Object)uri, (Object)domain);
            }
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            String filter = "{0}={1}";
            if (log.isDebugEnabled()) {
                log.debug("Searching [{}={}]...", (Object)domainConfig.getUserAttribute(), (Object)userName);
            }
            if (!(searchResults = searchCtxt.search(domainConfig.getBaseDnToUsers(), filter, new Object[]{domainConfig.getUserAttribute(), userName}, ctrl)).hasMoreElements()) {
                throw new SecurityException("User [" + userName + "] not found in domain [" + domain + "].");
            }
            SearchResult result = searchResults.next();
            String userDn = AdsHelper.getAbsoluteDn(uri, domainConfig.getBaseDnToUsers(), result);
            log.info("User [{}] found in domain [{}] resolved to DN [{}].", new Object[]{userName, domain, userDn});
            AdsPrincipal userPrincipal = AdsHelper.createPrincipal(domainConfig, result);
            searchCtxt.close();
            searchCtxt = null;
            AdsPrincipal adsPrincipal = userPrincipal;
            return adsPrincipal;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception during LDAP authentication", (Throwable)e);
            }
            DomainPrincipal domainPrincipal = null;
            return domainPrincipal;
        }
        finally {
            if (searchCtxt != null) {
                try {
                    searchCtxt.close();
                }
                catch (NamingException e) {
                    log.warn("Error closing LDAP context", (Throwable)e);
                }
            }
            if (ocl != null) {
                Thread.currentThread().setContextClassLoader(ocl);
            }
        }
    }

    public void sendPassword(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public synchronized void setGroupInfoCache(GroupInfoCache groupInfoCache) {
        this.groupInfoCache = groupInfoCache;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

