/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.ldap;

import java.util.List;
import javax.naming.NamingException;
import org.clazzes.util.sec.DomainGroup;

public class GroupInfo {
    private Boolean pending;
    private String errorMsg;
    private List<DomainGroup> groups;
    private long expiry;

    public GroupInfo(long expiry) {
        this.expiry = expiry;
    }

    public synchronized long getExpiry() {
        return this.expiry;
    }

    public synchronized List<DomainGroup> waitForResult(long timeout) throws NamingException, InterruptedException {
        if (this.pending == null) {
            this.pending = Boolean.TRUE;
            return null;
        }
        if (this.pending.booleanValue()) {
            this.wait(timeout);
        }
        if (this.pending.booleanValue()) {
            throw new NamingException("Wait for LDAP groups query timed out.");
        }
        if (this.groups == null) {
            throw new NamingException("LDAP groups query failed in a concurrent request: " + this.errorMsg);
        }
        return this.groups;
    }

    public synchronized void setResult(List<DomainGroup> groups) {
        this.groups = groups;
        this.pending = Boolean.FALSE;
        this.notifyAll();
    }

    public synchronized void setError(String errorMsg, long expiry) {
        this.errorMsg = errorMsg;
        this.expiry = expiry;
        this.pending = Boolean.FALSE;
        this.notifyAll();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

