/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.ldap;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiFunction;
import org.clazzes.login.ldap.DomainConfig;
import org.osgi.service.blueprint.container.ServiceUnavailableException;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements ManagedService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    public static final String CONFIG_PID = "org.clazzes.login.ldap";
    public static final String AUTHMETHOD_BINDADS = "bindAds";
    public static final String AUTHMETHOD_SEARCH_AND_BIND = "searchAndBind";
    private static final String DEFAULT_USER_ATTRIBUTE = "samAccountName";
    private static final String DEFAULT_PRETTYNAME_ATTRIBUTE = "cn";
    private static final String DEFAULT_EMAILADDRESS_ATTRIBUTE = "mail";
    private static final String DEFAULT_ALLOW_EMPTY_PASSWORDS = Boolean.toString(false);
    private static final String DEFAULT_ALLOW_GROUPS_FOR_DISABLED = Boolean.toString(true);
    private static final String DEFAULT_AUTH_MECHANISM = "simple";
    private String defaultDomain = null;
    private BiFunction<String, String, String> secretsService;
    private final Map<String, DomainConfig> domainControllers = new HashMap<String, DomainConfig>();

    public synchronized void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        Object s;
        Object object = s = properties == null ? null : (Object)properties.get("defaultDomain");
        if (s != null) {
            this.defaultDomain = s.toString();
            if (log.isDebugEnabled()) {
                log.debug("Setting default domain to [{}].", (Object)this.defaultDomain);
            }
        } else {
            this.defaultDomain = null;
            if (log.isDebugEnabled()) {
                log.debug("Setting default domain to default [{}].", (Object)this.defaultDomain);
            }
        }
        this.domainControllers.clear();
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith("domain.") || !key.endsWith(".controllerUri")) continue;
                String domain = key.substring(7, key.length() - 14);
                String uri_s = properties.get(key).toString();
                try {
                    URI uri = new URI(uri_s);
                    if (log.isDebugEnabled()) {
                        log.debug("Setting controller for domain [{}] to [{}].", (Object)domain, (Object)uri);
                    }
                    Object binduser = properties.get("domain." + domain + ".bindUser");
                    PasswordAuthentication auth = null;
                    if (binduser != null) {
                        String bindpw;
                        Object bindpw_o = properties.get("domain." + domain + ".bindPassword");
                        String string = bindpw = bindpw_o == null ? "" : bindpw_o.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("Setting bind credentials for domain [{}] to [{}].", (Object)domain, binduser);
                        }
                        if (bindpw.startsWith("secret::")) {
                            String skey = bindpw.substring(8);
                            try {
                                bindpw = this.secretsService.apply(CONFIG_PID, skey);
                                log.info("Resolved password secret [{}] from OSGi secrets service.", (Object)skey);
                            }
                            catch (ServiceUnavailableException e) {
                                log.warn("Cannot resolve password secret with no secrets service available.");
                            }
                        }
                        auth = new PasswordAuthentication(binduser.toString(), bindpw.toString().toCharArray());
                    }
                    String autMethod = this.getPropOrDefault(properties, domain, "autMethod", AUTHMETHOD_SEARCH_AND_BIND);
                    String authMethod = this.getPropOrDefault(properties, domain, "authMethod", autMethod);
                    String userAttribute = this.getPropOrDefault(properties, domain, "userAttribute", DEFAULT_USER_ATTRIBUTE);
                    String groupAttribute = this.getPropOrDefault(properties, domain, "groupAttribute", userAttribute);
                    String prettyNameAttribute = this.getPropOrDefault(properties, domain, "prettyNameAttribute", DEFAULT_PRETTYNAME_ATTRIBUTE);
                    String eMailAddressAttribute = this.getPropOrDefault(properties, domain, "eMailAddressAttribute", DEFAULT_EMAILADDRESS_ATTRIBUTE);
                    String mobileAttribute = this.getPropOrDefault(properties, domain, "mobileAttribute", null);
                    String tokenIdsAttribute = this.getPropOrDefault(properties, domain, "tokenIdsAttribute", null);
                    String allowEmptyPasswords = this.getPropOrDefault(properties, domain, "allowEmptyPasswords", DEFAULT_ALLOW_EMPTY_PASSWORDS);
                    String allowGroupsForDisabledUser = this.getPropOrDefault(properties, domain, "allowGroupsForDisabledUser", DEFAULT_ALLOW_GROUPS_FOR_DISABLED);
                    String authMechanism = this.getPropOrDefault(properties, domain, "authMechanism", DEFAULT_AUTH_MECHANISM);
                    String baseDnToUsers = this.getPropOrDefault(properties, domain, "baseDnToUsers", "");
                    String baseDnToGroups = this.getPropOrDefault(properties, domain, "baseDnToGroups", "");
                    long groupCacheSeconds = this.getPropOrDefault(properties, domain, "groupCacheSeconds", 300L);
                    long groupTimeoutSeconds = this.getPropOrDefault(properties, domain, "groupTimeoutSeconds", 30L);
                    this.domainControllers.put(domain, new DomainConfig(domain, uri, auth, authMethod, userAttribute, groupAttribute, prettyNameAttribute, eMailAddressAttribute, mobileAttribute, tokenIdsAttribute, Boolean.parseBoolean(allowEmptyPasswords), Boolean.parseBoolean(allowGroupsForDisabledUser), authMechanism, baseDnToUsers, baseDnToGroups, groupCacheSeconds, groupTimeoutSeconds));
                }
                catch (URISyntaxException e) {
                    throw new ConfigurationException("domainControllers", "Invalid format of domain controller URI [" + uri_s + "]: Invalid URI syntax: " + e.getMessage());
                }
            }
        }
    }

    private String getPropOrDefault(Dictionary<String, ?> properties, String domain, String what, String defaultValue) {
        Object configuredValue = properties.get("domain." + domain + "." + what);
        if (configuredValue == null) {
            if (log.isDebugEnabled()) {
                log.debug("Setting {} for domain [{}] to default [{}].", new Object[]{what, domain, defaultValue});
            }
            return defaultValue;
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting {} for domain [{}] to [{}].", new Object[]{what, domain, configuredValue});
        }
        return configuredValue.toString();
    }

    private long getPropOrDefault(Dictionary<String, ?> properties, String domain, String what, long defaultValue) {
        Object configuredValue = properties.get("domain." + domain + "." + what);
        if (configuredValue == null) {
            if (log.isDebugEnabled()) {
                log.debug("Setting {} for domain [{}] to default [{}].", new Object[]{what, domain, defaultValue});
            }
            return defaultValue;
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting {} for domain [{}] to [{}].", new Object[]{what, domain, configuredValue});
        }
        return Long.parseLong(configuredValue.toString());
    }

    public synchronized String getDefaultDomain() {
        return this.defaultDomain;
    }

    public synchronized List<String> getDomains() {
        Vector<String> domains = new Vector<String>(this.domainControllers.size());
        domains.addAll(this.domainControllers.keySet());
        return domains;
    }

    public synchronized void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public synchronized DomainConfig getDomainController(String domain) {
        return this.domainControllers.get(domain);
    }

    public void setSecretsService(BiFunction<String, String, String> secretsService) {
        this.secretsService = secretsService;
    }
}

