/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.ldap;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.clazzes.login.ldap.AdsGroup;
import org.clazzes.login.ldap.AdsPrincipal;
import org.clazzes.login.ldap.DomainConfig;
import org.clazzes.login.ldap.MFAAdsPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdsHelper {
    private static final Logger log = LoggerFactory.getLogger(AdsHelper.class);
    public static int USER_ACCOUNT_DISABLED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI querySRV(String dnsDomain, String srvName) throws NamingException {
        String[] dnsSRVQueryType = new String[]{"SRV"};
        String[] dnsTXTQueryType = new String[]{"TXT"};
        Hashtable<String, String> dnsEnv = new Hashtable<String, String>();
        dnsEnv.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try (InitialDirContext dnsContext = new InitialDirContext(dnsEnv);){
            Attributes dnsQueryResult;
            if (log.isDebugEnabled()) {
                log.debug("Starting DNS query for [SRV " + srvName + "]...");
            }
            if ((dnsQueryResult = dnsContext.getAttributes(srvName + "." + dnsDomain, dnsSRVQueryType)) == null) {
                throw new NamingException("SRV record [" + srvName + "] could not be found.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Parsing DNS query result for [SRV " + srvName + "].");
            }
            long minPriority = Long.MAX_VALUE;
            long maxWeight = Long.MIN_VALUE;
            Object found = null;
            int foundPort = -1;
            NamingEnumeration<? extends Attribute> dnsRR = dnsQueryResult.getAll();
            while (dnsRR.hasMoreElements()) {
                Attribute rr = dnsRR.next();
                NamingEnumeration<?> vals = rr.getAll();
                while (vals.hasMoreElements()) {
                    String srvRecord = vals.nextElement().toString();
                    if (log.isDebugEnabled()) {
                        log.debug("Found record [SRV " + srvRecord + "].");
                    }
                    StringTokenizer st = new StringTokenizer(srvRecord);
                    long priority = Long.parseLong(st.nextToken());
                    long weight = Long.parseLong(st.nextToken());
                    if (priority >= minPriority && (priority != minPriority || weight <= maxWeight)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Select record [SRV " + srvRecord + "].");
                    }
                    minPriority = priority;
                    maxWeight = weight;
                    foundPort = Integer.parseInt(st.nextToken());
                    found = st.nextToken();
                }
            }
            if (found == null) {
                throw new NamingException("Query for SRV [" + srvName + "] returned an empty result set.");
            }
            found = ((String)found).endsWith(".") ? ((String)found).substring(0, ((String)found).length() - 1) : (String)found + "." + dnsDomain;
            log.info("Resolved SRV record [" + srvName + "] to [" + (String)found + "].");
            if (log.isDebugEnabled()) {
                log.debug("Starting DNS query for [TXT " + (String)found + "]...");
            }
            if ((dnsQueryResult = dnsContext.getAttributes((String)found, dnsTXTQueryType)) == null) {
                throw new NamingException("TXT record [" + (String)found + "] could not be found.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Parsing DNS query result for [TXT " + (String)found + "].");
            }
            URI ret = null;
            NamingEnumeration<? extends Attribute> dnsRR2 = dnsQueryResult.getAll();
            while (dnsRR2.hasMoreElements()) {
                Attribute rr = dnsRR2.next();
                NamingEnumeration<?> vals = rr.getAll();
                while (vals.hasMoreElements()) {
                    String txtRecord = vals.nextElement().toString();
                    if (log.isDebugEnabled()) {
                        log.debug("Found record [TXT " + txtRecord + "].");
                    }
                    if (!txtRecord.startsWith("service:ldap://") && !txtRecord.startsWith("service:ldaps://")) continue;
                    try {
                        ret = new URI(txtRecord.substring(8));
                        log.info("Resolved TXT record [" + (String)found + "] to [" + String.valueOf(ret) + "].");
                    }
                    catch (URISyntaxException e) {
                        log.warn("Record [TXT " + txtRecord + "] does not contain a well-formatted ldap-URI.");
                    }
                }
            }
            if (ret == null) {
                try {
                    String bindDN = AdsHelper.convertDomainToDN(dnsDomain);
                    ret = new URI("ldap", null, (String)found, foundPort, bindDN, null, null);
                    if (log.isDebugEnabled()) {
                        log.debug("Record [TXT " + (String)found + "] was not of type service:ldap(s), final URI from SRV record is [" + String.valueOf(ret) + "].");
                    }
                }
                catch (URISyntaxException e) {
                    throw new NamingException("Unable to build a valid URI from SRV record [" + (String)found + "].");
                }
            }
            URI uRI = ret;
            return uRI;
        }
    }

    public static URI findAds(String dnsDomain) throws NamingException {
        return AdsHelper.querySRV(dnsDomain, "_ldap._tcp");
    }

    public static URI findGCServer(String dnsDomain) throws NamingException {
        return AdsHelper.querySRV(dnsDomain, "_ldap._tcp.gc._msdcs");
    }

    public static String convertDomainToDN(String dnsDomain) {
        int pos;
        StringBuffer dc = new StringBuffer();
        int opos = 0;
        while ((pos = dnsDomain.indexOf(46, opos)) >= opos) {
            dc.append(opos > 0 ? (char)',' : '/');
            dc.append("dc=");
            dc.append(dnsDomain.substring(opos, pos));
            opos = pos + 1;
        }
        if (dnsDomain.length() > opos) {
            dc.append(opos > 0 ? (char)',' : '/');
            dc.append("dc=");
            dc.append(dnsDomain.substring(opos));
        }
        return dc.toString();
    }

    public static URI resolveServerURI(String uriString) throws NamingException, URISyntaxException {
        URI uri = new URI(uriString);
        return AdsHelper.resolveServerURI(uri);
    }

    private static URI addSubContext(URI uri, String subContext) throws NamingException {
        if (subContext != null && subContext.startsWith("/")) {
            String subPath = uri.getPath() == null || !uri.getPath().startsWith("/") ? subContext : subContext + "," + uri.getPath().substring(1);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Resolved ADS subContext [{}] to absolute path [{}].", (Object)subContext, (Object)subPath);
                }
                return new URI(uri.getScheme(), uri.getHost(), subPath, uri.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new NamingException("Cannot append subcontext [" + subContext + "] to URI [" + String.valueOf(uri) + "]: " + e.getMessage());
            }
        }
        return uri;
    }

    private static URI changeLDAPToLDAPS(URI uri) throws URISyntaxException {
        if (uri != null && "ldap".equals(uri.getScheme())) {
            return new URI("ldaps", uri.getHost(), uri.getPath(), uri.getQuery(), null);
        }
        return uri;
    }

    public static URI resolveServerURI(URI uri) throws NamingException, URISyntaxException {
        URI ret;
        if ("ldap".equals(uri.getScheme()) || "ldaps".equals(uri.getScheme())) {
            ret = uri;
        } else if ("ads".equals(uri.getScheme())) {
            ret = AdsHelper.addSubContext(AdsHelper.findAds(uri.getHost()), uri.getPath());
        } else if ("adss".equals(uri.getScheme())) {
            ret = AdsHelper.changeLDAPToLDAPS(AdsHelper.addSubContext(AdsHelper.findAds(uri.getHost()), uri.getPath()));
        } else if ("gc".equals(uri.getScheme())) {
            ret = AdsHelper.addSubContext(AdsHelper.findGCServer(uri.getHost()), uri.getPath());
        } else if ("gcs".equals(uri.getScheme())) {
            ret = AdsHelper.changeLDAPToLDAPS(AdsHelper.addSubContext(AdsHelper.findGCServer(uri.getHost()), uri.getPath()));
        } else {
            throw new NamingException("Unsupported URI scheme [" + uri.getScheme() + "] given.");
        }
        return ret;
    }

    public static LdapContext connectToADS(URI url, PasswordAuthentication auth, String authMechanism) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url.toString());
        env.put("java.naming.referral", "follow");
        if (auth == null) {
            if (log.isDebugEnabled()) {
                log.debug("Binding anonymously to URL [" + String.valueOf(url) + "].");
            }
            env.put("java.naming.security.authentication", "none");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Binding as user [" + auth.getUserName() + "] to URL [" + String.valueOf(url) + "] with mechanism [" + authMechanism + "].");
            }
            env.put("java.naming.security.authentication", authMechanism);
            env.put("java.naming.security.principal", auth.getUserName());
            env.put("java.naming.security.credentials", new String(auth.getPassword()));
        }
        return new InitialLdapContext(env, null);
    }

    public static AdsPrincipal createPrincipal(DomainConfig domainConfig, SearchResult result) throws NamingException {
        if (domainConfig == null || result == null) {
            return null;
        }
        String userDn = result.getName();
        Attributes userAttributes = result.getAttributes();
        String userName = userDn;
        String prettyName = userDn;
        String eMailAddress = null;
        if (userAttributes == null) {
            log.warn("Search result with DN [" + userDn + "] has no attributes");
        } else {
            Attribute userNameAttribute = userAttributes.get(domainConfig.getUserAttribute());
            if (userNameAttribute == null || userNameAttribute.get() == null) {
                log.warn("Search result with DN [" + userDn + "] without userName attribute " + domainConfig.getUserAttribute());
            } else {
                userName = userNameAttribute.get().toString();
                log.debug("Search result with DN [" + userDn + "] has userName attribute " + domainConfig.getUserAttribute() + " with value " + userName);
            }
            Attribute prettyNameAttribute = userAttributes.get(domainConfig.getPrettyNameAttribute());
            if (prettyNameAttribute == null || prettyNameAttribute.get() == null) {
                log.warn("Search result with DN [" + userDn + "] without prettyName attribute " + domainConfig.getPrettyNameAttribute());
            } else {
                prettyName = prettyNameAttribute.get().toString();
                log.debug("Search result with DN [" + userDn + "] has prettyName attribute " + domainConfig.getPrettyNameAttribute() + " with value " + prettyName);
            }
            Attribute mailAttribute = userAttributes.get(domainConfig.getEMailAddressAttribute());
            if (mailAttribute == null || mailAttribute.get() == null) {
                log.warn("Search result with DN [" + userDn + "] without eMailAddress attribute " + domainConfig.getEMailAddressAttribute());
            } else {
                eMailAddress = mailAttribute.get().toString();
                log.debug("Search result with DN [" + userDn + "] has eMailAddress attribute " + domainConfig.getEMailAddressAttribute() + " with value " + String.valueOf(mailAttribute));
            }
        }
        String ma = domainConfig.getMobileAttribute();
        String tka = domainConfig.getTokenIdsAttribute();
        if (ma == null && tka == null) {
            return new AdsPrincipal(userName, domainConfig.getDomain(), prettyName, eMailAddress);
        }
        String mobileNumber = null;
        String[] tokenIds = null;
        Attribute mobileAttribute = userAttributes.get(ma);
        if (mobileAttribute == null || mobileAttribute.get() == null) {
            log.warn("Search result with DN [" + userDn + "] without mobile attribute " + ma);
        } else {
            mobileNumber = mobileAttribute.get().toString();
            log.debug("Search result with DN [" + userDn + "] has mobile attribute " + ma + " with value " + String.valueOf(mobileAttribute));
        }
        Attribute tokenIdsAttribute = userAttributes.get(tka);
        if (tokenIdsAttribute == null || tokenIdsAttribute.get() == null) {
            log.warn("Search result with DN [" + userDn + "] without tokenIds attribute " + ma);
        } else {
            String tokenIds_s = tokenIdsAttribute.get().toString();
            log.debug("Search result with DN [" + userDn + "] has tokenIds attribute " + ma + " with value " + String.valueOf(tokenIdsAttribute));
            tokenIds = tokenIds_s.trim().split("\\s+");
        }
        return new MFAAdsPrincipal(userName, domainConfig.getDomain(), prettyName, eMailAddress, mobileNumber, tokenIds);
    }

    public static AdsGroup createGroup(DomainConfig domainConfig, SearchResult result) throws NamingException {
        if (domainConfig == null || result == null) {
            return null;
        }
        String groupDn = result.getName();
        Attributes groupAttributes = result.getAttributes();
        String groupName = groupDn;
        String prettyName = groupDn;
        if (groupAttributes == null) {
            log.warn("Search result with DN [" + groupDn + "] has no attributes");
        } else {
            Attribute groupNameAttribute = groupAttributes.get(domainConfig.getGroupAttribute());
            if (groupNameAttribute == null || groupNameAttribute.get() == null) {
                log.warn("Search result with DN [" + groupDn + "] without attribute " + domainConfig.getGroupAttribute());
            } else {
                groupName = groupNameAttribute.get().toString();
                log.debug("Search result with DN [" + groupDn + "] has groupName attribute " + domainConfig.getGroupAttribute() + " with value " + groupName);
            }
            Attribute prettyNameAttribute = groupAttributes.get(domainConfig.getPrettyNameAttribute());
            if (prettyNameAttribute == null || prettyNameAttribute.get() == null) {
                log.warn("Search result with DN [" + groupDn + "] without attribute " + domainConfig.getPrettyNameAttribute());
            } else {
                prettyName = prettyNameAttribute.get().toString();
                log.debug("Search result with DN [" + groupDn + "] has prettyName attribute " + domainConfig.getPrettyNameAttribute() + " with value " + prettyName);
            }
        }
        return new AdsGroup(groupName, domainConfig.getDomain(), prettyName);
    }

    public static String getAbsoluteDn(URI uri, String additionalBasePath, SearchResult gotResult) throws InvalidNameException {
        if (!gotResult.isRelative()) {
            return gotResult.getName();
        }
        String baseDnUriPathString = uri.getPath() == null ? "" : (uri.getPath().startsWith("/") ? uri.getPath().substring(1) : uri.getPath());
        LdapName baseDnOFUriPath = new LdapName(baseDnUriPathString);
        LdapName baseDnSearchedSubTree = new LdapName(additionalBasePath);
        LdapName relativeDn = new LdapName(gotResult.getName());
        Name fullDn = baseDnOFUriPath.addAll(baseDnSearchedSubTree).addAll(relativeDn);
        return fullDn.toString();
    }

    public static String getRelativeDn(URI uri, String additionalBasePath, String absolutePath) throws InvalidNameException {
        LdapName baseDnSearchedSubTree;
        LdapName absoluteDn = new LdapName(absolutePath);
        String baseDnUriPathString = uri.getPath() == null ? "" : (uri.getPath().startsWith("/") ? uri.getPath().substring(1) : uri.getPath());
        LdapName baseDnOfUriPath = new LdapName(baseDnUriPathString);
        Name fullBaseDn = baseDnOfUriPath.addAll(baseDnSearchedSubTree = new LdapName(additionalBasePath));
        if (((Object)absoluteDn).equals(fullBaseDn)) {
            return "";
        }
        if (absoluteDn.size() <= fullBaseDn.size()) {
            return null;
        }
        if (!absoluteDn.startsWith(fullBaseDn)) {
            return null;
        }
        Name relativePath = absoluteDn.getSuffix(fullBaseDn.size());
        return relativePath.toString();
    }

    public static boolean isDisabledAdUser(Attributes userAttributes) throws NamingException {
        Attribute userAccountControl = userAttributes.get("userAccountControl");
        if (userAccountControl == null || userAccountControl.get() == null) {
            log.trace("userAccountControl was null");
            return false;
        }
        String attributeValue = userAccountControl.get().toString();
        int intValue = Integer.parseInt(attributeValue);
        return (intValue & USER_ACCOUNT_DISABLED) > 0;
    }
}

