/**
 * 
 */
package org.clazzes.login.ldap;

/**
 * A cache for group informations
 */
public interface GroupInfoCache {

    /**
     * Get group info cache bucket for a given domain/user combination.
     * 
     * @param domain The domain name.
     * @param user The user name.
     * @param expiry The expiry timestamp used, if a new {@link GroupInfo} will be instantiated.
     * @return A group info bucket. If the bucket returns <code>null</code> from {@link GroupInfo#waitForResult(long)},
     *         the calling task is responsible for filling in the actual result by {@link GroupInfo#setResult(java.util.List)}.
     */
    public GroupInfo getGroupInfo(String domain, String user, long expiry);
}
