/**
 * 
 */
package org.clazzes.login.ldap;

import java.util.List;

import javax.naming.NamingException;

import org.clazzes.util.sec.DomainGroup;

/**
 * A cached group information.
 */
public class GroupInfo {

    private Boolean pending;
    private String errorMsg;
    
    private List<DomainGroup> groups;
    private long expiry;
    
    public GroupInfo(long expiry) {
        this.expiry = expiry;
    }
    
    public synchronized long getExpiry() {
        return this.expiry;
    }

    /**
     * Wait for a result from a concurrent system. If <code>null</code> is returned,
     * the calling thread is responsible for performing the actual LDA query
     * and calling {@link #setResult(List)} in a finally block.
     * 
     * @param timeout The timeout to wait for the result.
     * @return The list of groups or <code>null</code>, if we are responsible for querying
     *         the LDAP server.
     * @throws NamingException Upon exceptions from the concurrent query.
     * @throws InterruptedException If the calling thread has been interrupted.
     */
    public synchronized List<DomainGroup> waitForResult(long timeout) throws NamingException, InterruptedException {
        
        if (this.pending == null) {
            this.pending = Boolean.TRUE;
            return null;
        }
        
        if (this.pending.booleanValue()) {
            this.wait(timeout);
        }
        
        if (this.pending.booleanValue()) {
            throw new NamingException("Wait for LDAP groups query timed out.");
        }
            
        if (this.groups == null) {
            throw new NamingException("LDAP groups query failed in a concurrent request: " + this.errorMsg);
        }

        return this.groups;
    }
    
    public synchronized void setResult(List<DomainGroup> groups) {
        
        this.groups = groups;
        this.pending = Boolean.FALSE;
        this.notifyAll();
    }
    
    public synchronized void setError(String errorMsg, long expiry) {
        
        this.errorMsg = errorMsg;
        this.expiry = expiry;
        this.pending = Boolean.FALSE;
        this.notifyAll();
    }

    @Override
    public int hashCode() {
        // Intentionally not implemented as we need object identity in the garbage collector.
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        // Intentionally not implemented as we need object identity in the garbage collector.
        return super.equals(obj);
    }
    
    
}
