/***********************************************************
 * $Id$
 * 
 * http://www.clazzes.org
 *
 * Created: 02.04.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.ldap;

import org.clazzes.util.sec.DomainPrincipal;

/**
 * An authenticated Active Directory user.
 */
public class AdsPrincipal implements DomainPrincipal {

    private final String user;
    private final String domain;
    private final String prettyName;
    private final String eMailAddress;

    public AdsPrincipal(String user, String domain, String prettyName, String eMailAddress) {
        super();
        this.user = user;
        this.domain = domain;
        this.prettyName = prettyName;
        this.eMailAddress = eMailAddress;
    }

    @Override
    public String getName() {
        return this.domain + "/" + this.user;
    }

    /**
     * 
     * @return The authenticated ADS user.
     */
    public String getUserName() {
        return this.user;
    }

    /**
     * @return The ADS domain against which the user has been authenticated.
     */
    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        return "AdsPrincipal["+this.getName()+"]";
    }

    /**
     * @return the pretty name
     */
    public String getPrettyName() {
        return this.prettyName;
    }


    public String getEMailAddress() {
        return this.eMailAddress;
    }

}
