/***********************************************************
 * $Id$
 * 
 * http://www.clazzes.org
 *
 * Created: 02.04.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.ldap;

import org.clazzes.util.sec.DomainGroup;


public class AdsGroup implements DomainGroup {

    private final String group;
    private final String domain;
    private final String prettyName;

    public AdsGroup(String groupName, String domain, String prettyName) {
        super();
        this.group = groupName;
        this.domain = domain;
        this.prettyName = prettyName;
    }

    @Override
    public String getName() {
        return this.domain + "/" + this.group;
    }

    @Override
    public String getGroupName() {
        return this.group;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }


    public String toString() {
        return "AdsGroup["+this.getName()+"]";
    }

    public String getPrettyName() {
        return this.prettyName;
    }

}
