/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HexFormat;
import org.clazzes.login.jbo.json.JsonHelper;
import org.clazzes.login.jbo.u2f.DeviceRegistry;
import org.clazzes.login.jbo.u2f.DeviceSelector;
import org.clazzes.login.jbo.u2f.X509DeviceSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeviceRegistryParser {
    private static final Logger log = LoggerFactory.getLogger(DeviceRegistryParser.class);
    private static final CertificateFactory certificateFactory;
    private static final SimpleModule customModule;

    public static final DeviceRegistry parseJson(InputStream is) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)customModule);
        try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            DeviceRegistry deviceRegistry = (DeviceRegistry)mapper.readValue((Reader)reader, DeviceRegistry.class);
            return deviceRegistry;
        }
    }

    static {
        customModule = new SimpleModule();
        customModule.addDeserializer(X509Certificate.class, (JsonDeserializer)new CertificateDeserializer());
        customModule.addDeserializer(DeviceSelector.class, (JsonDeserializer)new DeviceSelectorDeserializer());
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("X.509 CertificateFactory could not be instantiated.", e);
        }
    }

    private static class CertificateDeserializer
    extends JsonDeserializer<X509Certificate> {
        private CertificateDeserializer() {
        }

        public X509Certificate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String s = p.getText();
            try {
                return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(s.getBytes("US-ASCII")));
            }
            catch (CertificateException e) {
                throw new IOException("Unable to parse certificate from JSON attribute.", e);
            }
        }
    }

    private static class DeviceSelectorDeserializer
    extends JsonDeserializer<DeviceSelector> {
        private DeviceSelectorDeserializer() {
        }

        public DeviceSelector deserialize(JsonParser p, DeserializationContext dctxt) throws IOException, JacksonException {
            String ctxt = "DeviceSelector";
            JsonHelper.beginObject(p, ctxt);
            String key = JsonHelper.nextName(p, ctxt);
            if (!"type".equals(key)) {
                throw new IllegalArgumentException("Device Selector does not start with a [type] attribute.");
            }
            String type = JsonHelper.nextString(p, ctxt);
            if (!"x509Extension".equals(type)) {
                throw new IllegalArgumentException("Device Selector has a type different from [x509Extension].");
            }
            key = JsonHelper.nextName(p, ctxt);
            if (!"parameters".equals(key)) {
                throw new IllegalArgumentException("Device Selector does not contain a [parameters] attribute.");
            }
            JsonHelper.beginObject(p, ctxt);
            String oid = null;
            Object value = null;
            while ((key = JsonHelper.nextName(p, ctxt)) != null) {
                if ("key".equals(key)) {
                    oid = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("value".equals(key)) {
                    JsonToken token = p.nextToken();
                    if (token == JsonToken.START_OBJECT) {
                        key = JsonHelper.nextName(p, ctxt);
                        if (!"type".equals(key)) {
                            throw new IllegalArgumentException("X509Extension Device Selector value does not start with a [type] attribute.");
                        }
                        type = JsonHelper.nextString(p, ctxt);
                        if (!"hex".equals(type)) {
                            throw new IllegalArgumentException("X509Extension Device Selector value has a type different from [hex].");
                        }
                        key = JsonHelper.nextName(p, ctxt);
                        if (!"value".equals(key)) {
                            throw new IllegalArgumentException("X509Extension Device Selector value does not contain a [value] attribute.");
                        }
                        value = HexFormat.of().parseHex(JsonHelper.nextString(p, ctxt));
                        p.nextToken();
                        JsonHelper.endObject(p, ctxt);
                        continue;
                    }
                    if (token == JsonToken.VALUE_NUMBER_INT) {
                        value = p.getIntValue();
                        continue;
                    }
                    value = p.getText();
                    continue;
                }
                throw new IllegalArgumentException("X509Extension Device Selector contains unknown attribute [" + key + "].");
            }
            JsonHelper.endObject(p, ctxt);
            p.nextToken();
            JsonHelper.endObject(p, ctxt);
            if (oid == null) {
                throw new IllegalArgumentException("X509Extension Device Selector does not contain a [key] attribute.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Parsed X509DeviceSelector: oid={},value={}", (Object)oid, value);
            }
            return new X509DeviceSelector(oid, value);
        }
    }
}

