/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.json.JsonHelper;
import org.clazzes.login.jbo.u2f.AuthenticatorAssertionResponse;
import org.clazzes.login.jbo.u2f.AuthenticatorAttestationResponse;
import org.clazzes.login.jbo.u2f.ClientData;
import org.clazzes.login.jbo.u2f.PublicKeyCredential;
import org.clazzes.login.jbo.u2f.SafetyNetPayload;
import org.clazzes.login.jbo.u2f.SafetyNetSignatureHeader;

public abstract class CredentialParser {
    private static final SimpleModule commonModule;
    private static final SimpleModule attestationModule;
    private static final SimpleModule assertionModule;
    private static final CertificateFactory certificateFactory;

    public static PublicKeyCredential parseAttestationCredentials(Reader json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)attestationModule);
        return (PublicKeyCredential)objectMapper.readValue(json, PublicKeyCredential.class);
    }

    public static PublicKeyCredential parseAttestationCredentials(String json) throws IOException {
        try (StringReader r = new StringReader(json);){
            PublicKeyCredential publicKeyCredential = CredentialParser.parseAttestationCredentials(r);
            return publicKeyCredential;
        }
    }

    public static PublicKeyCredential parseAttestationCredentials(InputStream is) throws IOException {
        try (InputStreamReader json = new InputStreamReader(is, "UTF-8");){
            PublicKeyCredential publicKeyCredential = CredentialParser.parseAttestationCredentials(json);
            return publicKeyCredential;
        }
    }

    public static PublicKeyCredential parseAttestationCredentials(byte[] attestationCredentials) throws IOException {
        return CredentialParser.parseAttestationCredentials(new ByteArrayInputStream(attestationCredentials));
    }

    public static PublicKeyCredential parseAssertionCredentials(Reader json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)assertionModule);
        return (PublicKeyCredential)objectMapper.readValue(json, PublicKeyCredential.class);
    }

    public static PublicKeyCredential parseAssertionCredentials(String json) throws IOException {
        try (StringReader r = new StringReader(json);){
            PublicKeyCredential publicKeyCredential = CredentialParser.parseAssertionCredentials(r);
            return publicKeyCredential;
        }
    }

    public static PublicKeyCredential parseAssertionCredentials(InputStream is) throws IOException {
        try (InputStreamReader json = new InputStreamReader(is, "UTF-8");){
            PublicKeyCredential publicKeyCredential = CredentialParser.parseAssertionCredentials(json);
            return publicKeyCredential;
        }
    }

    public static PublicKeyCredential parseAssertionCredentials(byte[] assertionCredentials) throws IOException {
        return CredentialParser.parseAssertionCredentials(new ByteArrayInputStream(assertionCredentials));
    }

    public static ClientData parseClientData(Reader json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)commonModule);
        return (ClientData)objectMapper.readValue(json, ClientData.class);
    }

    public static ClientData parseClientData(String json) throws IOException {
        try (StringReader r = new StringReader(json);){
            ClientData clientData = CredentialParser.parseClientData(r);
            return clientData;
        }
    }

    public static ClientData parseClientData(InputStream is) throws IOException {
        try (InputStreamReader json = new InputStreamReader(is, "UTF-8");){
            ClientData clientData = CredentialParser.parseClientData(json);
            return clientData;
        }
    }

    public static ClientData parseClientData(byte[] clientData) throws IOException {
        return CredentialParser.parseClientData(new ByteArrayInputStream(clientData));
    }

    public static SafetyNetPayload parseSafetyNetPayload(Reader json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)commonModule);
        return (SafetyNetPayload)objectMapper.readValue(json, SafetyNetPayload.class);
    }

    public static SafetyNetPayload parseSafetyNetPayload(String json) throws IOException {
        try (StringReader r = new StringReader(json);){
            SafetyNetPayload safetyNetPayload = CredentialParser.parseSafetyNetPayload(r);
            return safetyNetPayload;
        }
    }

    public static SafetyNetPayload parseSafetyNetPayload(InputStream is) throws IOException {
        try (InputStreamReader json = new InputStreamReader(is, "UTF-8");){
            SafetyNetPayload safetyNetPayload = CredentialParser.parseSafetyNetPayload(json);
            return safetyNetPayload;
        }
    }

    public static SafetyNetPayload parseSafetyNetPayload(byte[] safetyNetPayload) throws IOException {
        return CredentialParser.parseSafetyNetPayload(new ByteArrayInputStream(safetyNetPayload));
    }

    public static SafetyNetSignatureHeader parseSafetyNetSignatureHeader(Reader json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)commonModule);
        return (SafetyNetSignatureHeader)objectMapper.readValue(json, SafetyNetSignatureHeader.class);
    }

    public static SafetyNetSignatureHeader parseSafetyNetSignatureHeader(String json) throws IOException {
        try (StringReader r = new StringReader(json);){
            SafetyNetSignatureHeader safetyNetSignatureHeader = CredentialParser.parseSafetyNetSignatureHeader(r);
            return safetyNetSignatureHeader;
        }
    }

    public static SafetyNetSignatureHeader parseSafetyNetSignatureHeader(InputStream is) throws IOException {
        try (InputStreamReader json = new InputStreamReader(is, "UTF-8");){
            SafetyNetSignatureHeader safetyNetSignatureHeader = CredentialParser.parseSafetyNetSignatureHeader(json);
            return safetyNetSignatureHeader;
        }
    }

    public static SafetyNetSignatureHeader parseSafetyNetSignatureHeader(byte[] safetyNetPayload) throws IOException {
        return CredentialParser.parseSafetyNetSignatureHeader(new ByteArrayInputStream(safetyNetPayload));
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("X.509 CertificateFactory could not be instantiated.", e);
        }
        commonModule = new SimpleModule();
        commonModule.addDeserializer(X509Certificate.class, (JsonDeserializer)new B64CertificateDeserializer());
        commonModule.addDeserializer(byte[].class, (JsonDeserializer)new B64ByteArrayDeserializer());
        attestationModule = new SimpleModule();
        attestationModule.addDeserializer(byte[].class, (JsonDeserializer)new B64ByteArrayDeserializer());
        attestationModule.addDeserializer(PublicKeyCredential.class, (JsonDeserializer)new AttestationPublicKeyCredentialDeserializer());
        assertionModule = new SimpleModule();
        assertionModule.addDeserializer(byte[].class, (JsonDeserializer)new B64ByteArrayDeserializer());
        assertionModule.addDeserializer(PublicKeyCredential.class, (JsonDeserializer)new AssertionPublicKeyCredentialDeserializer());
    }

    private static class B64CertificateDeserializer
    extends JsonDeserializer<X509Certificate> {
        private B64CertificateDeserializer() {
        }

        public X509Certificate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String b64 = p.getText();
            try {
                return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Helpers.parseBase64(b64)));
            }
            catch (CertificateException e) {
                throw new IOException("Unable to parse certificate from JSON attribute.", e);
            }
        }
    }

    private static class B64ByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        private B64ByteArrayDeserializer() {
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String b64 = p.getText();
            return Helpers.parseBase64(b64);
        }
    }

    private static final class AttestationPublicKeyCredentialDeserializer
    extends JsonDeserializer<PublicKeyCredential> {
        private AttestationPublicKeyCredentialDeserializer() {
        }

        public PublicKeyCredential deserialize(JsonParser p, DeserializationContext dctxt) throws IOException, JacksonException {
            String key;
            String ctxt = "AttestationPublicKeyCredential";
            JsonHelper.beginObject(p, ctxt);
            byte[] id = null;
            AuthenticatorAttestationResponse response = null;
            while ((key = JsonHelper.nextName(p, ctxt)) != null) {
                if ("id".equals(key)) {
                    id = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("response".equals(key)) {
                    String k;
                    byte[] clientData = null;
                    byte[] attestationObject = null;
                    JsonHelper.beginObject(p, ctxt);
                    while ((k = JsonHelper.nextName(p, ctxt)) != null) {
                        if ("clientDataJSON".equals(k)) {
                            clientData = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                            continue;
                        }
                        if ("attestationObject".equals(k)) {
                            attestationObject = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown key [" + k + "] in AuthenticatorAttestationResponse.");
                    }
                    response = new AuthenticatorAttestationResponse(clientData, attestationObject);
                    continue;
                }
                if (!"clientExtensionResults".equals(key) || !JsonHelper.beginObjectOrNull(p, ctxt) || JsonHelper.nextName(p, ctxt) == null) continue;
                throw new IllegalArgumentException("Only empty clientExtensionResults are supported.");
            }
            return new PublicKeyCredential(id, response);
        }
    }

    private static final class AssertionPublicKeyCredentialDeserializer
    extends JsonDeserializer<PublicKeyCredential> {
        private AssertionPublicKeyCredentialDeserializer() {
        }

        public PublicKeyCredential deserialize(JsonParser p, DeserializationContext dctxt) throws IOException, JacksonException {
            String key;
            String ctxt = "AssertionPublicKeyCredential";
            JsonHelper.beginObject(p, ctxt);
            byte[] id = null;
            AuthenticatorAssertionResponse response = null;
            while ((key = JsonHelper.nextName(p, ctxt)) != null) {
                if ("id".equals(key)) {
                    id = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("response".equals(key)) {
                    String k;
                    byte[] clientData = null;
                    byte[] authenticatorData = null;
                    byte[] signature = null;
                    byte[] userHandle = null;
                    JsonHelper.beginObject(p, ctxt);
                    while ((k = JsonHelper.nextName(p, ctxt)) != null) {
                        if ("clientDataJSON".equals(k)) {
                            clientData = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                            continue;
                        }
                        if ("authenticatorData".equals(k)) {
                            authenticatorData = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                            continue;
                        }
                        if ("signature".equals(k)) {
                            signature = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                            continue;
                        }
                        if ("userHandle".equals(k)) {
                            userHandle = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown key [" + k + "] in AuthenticatorAssertionResponse.");
                    }
                    response = new AuthenticatorAssertionResponse(clientData, authenticatorData, signature, userHandle);
                    continue;
                }
                if (!"clientExtensionResults".equals(key) || !JsonHelper.beginObjectOrNull(p, ctxt) || JsonHelper.nextName(p, ctxt) == null) continue;
                throw new IllegalArgumentException("Only empty clientExtensionResults are supported.");
            }
            return new PublicKeyCredential(id, response);
        }
    }
}

