/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.clazzes.login.jbo.bc.BCTools;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.ExtensionFormat;
import org.clazzes.login.jbo.common.IExtensionConsumer;
import org.clazzes.login.jbo.common.PubKeyInfo;
import org.clazzes.login.jbo.u2f.AttestationCertInfo;
import org.clazzes.login.jbo.u2f.AttestationCertValidator;
import org.clazzes.login.jbo.u2f.AttestationResult;
import org.clazzes.login.jbo.u2f.AttestationType;
import org.clazzes.login.jbo.u2f.DeviceInfo;
import org.clazzes.login.jbo.u2f.DeviceRegistry;
import org.clazzes.login.jbo.u2f.json.DeviceRegistryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttestationCertValidatorImpl
implements AttestationCertValidator {
    private static final Logger log = LoggerFactory.getLogger(AttestationCertValidatorImpl.class);
    private static final DeviceRegistry yubicoRegistry;
    private static final CertPathBuilder certPathBuilder;
    private static final CertPathValidator certPathValidator;
    private static final TrustManagerFactory trustManagerFactory;
    private static final Set<TrustAnchor> jceTrustAnchors;
    private static final Map<String, ExtensionFormat> extensionFormats;
    private Date validationDate;
    private final Map<UUID, DeviceRegistry> deviceRegistries = new HashMap<UUID, DeviceRegistry>();
    private final Map<UUID, Set<TrustAnchor>> trustAnchorsByRegistryUUID = new HashMap<UUID, Set<TrustAnchor>>();

    @Override
    public AttestationCertInfo parseCertificate(Algorithm algorithm, X509Certificate cert) throws CertificateEncodingException {
        final HashMap<String, Object> extensionValues = new HashMap<String, Object>();
        String keyId = cert.getSubjectX500Principal().getName();
        PubKeyInfo pubKeyInfo = BCTools.getPubKeyInfo(algorithm, keyId, cert, new IExtensionConsumer(){

            @Override
            public void consumeOctetString(String oid, byte[] data) {
                if ("1.3.6.1.4.1.45724.1.1.4".equals(oid)) {
                    extensionValues.put(oid, data);
                } else if ("1.3.6.1.4.1.41482.2".equals(oid)) {
                    try {
                        extensionValues.put(oid, new String(data, "US-ASCII"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("US-ASCII not supported.", e);
                    }
                }
            }

            @Override
            public void consumeBitString(String oid, byte[] data, int padBits) {
                if ("1.3.6.1.4.1.45724.2.1.1".equals(oid)) {
                    extensionValues.put(oid, Integer.reverse((data[0] & 0xFF) << 24));
                }
            }

            @Override
            public Iterator<String> getSupportedOids() {
                return extensionFormats.keySet().iterator();
            }

            @Override
            public ExtensionFormat getExtensionFormat(String oid) {
                return extensionFormats.get(oid);
            }
        });
        return new AttestationCertInfo(extensionValues, pubKeyInfo);
    }

    public void addDeviceRegistry(DeviceRegistry deviceRegistry) {
        this.deviceRegistries.put(deviceRegistry.getIdentifier(), deviceRegistry);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : deviceRegistry.getTrustedCertificates()) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        this.trustAnchorsByRegistryUUID.put(deviceRegistry.getIdentifier(), trustAnchors);
    }

    public AttestationCertValidatorImpl() {
        this(true);
    }

    public AttestationCertValidatorImpl(boolean loadDefaultRegistries) {
        if (loadDefaultRegistries) {
            this.addDeviceRegistry(yubicoRegistry);
        }
    }

    @Override
    public AttestationResult validateCertificateChain(Algorithm algorithm, X509Certificate[] chain) throws Exception {
        if (chain == null || chain.length < 1) {
            throw new IllegalArgumentException("Attestation certificate chain is empty.");
        }
        AttestationCertInfo aci = this.parseCertificate(algorithm, chain[0]);
        DeviceInfo di = null;
        Set<TrustAnchor> trustAnchors = null;
        DeviceRegistry registry = null;
        for (Map.Entry<UUID, DeviceRegistry> e : this.deviceRegistries.entrySet()) {
            di = e.getValue().selectDevice(aci);
            if (di == null) continue;
            trustAnchors = this.trustAnchorsByRegistryUUID.get(e.getKey());
            registry = e.getValue();
            break;
        }
        if (di == null || trustAnchors == null) {
            throw new SecurityException("Device for attestation certificate [" + String.valueOf(aci) + "] could not be found.");
        }
        log.info("Found device [{}] for attestation certificate [{}] in registry [{}].", new Object[]{di.getDisplayName(), aci, registry.getVendorInfo().getName()});
        CollectionCertStoreParameters cp = new CollectionCertStoreParameters(Arrays.asList(chain));
        CertStore store = CertStore.getInstance("Collection", cp);
        X509CertSelector cs = new X509CertSelector();
        cs.setCertificate(chain[0]);
        PKIXBuilderParameters pbp = new PKIXBuilderParameters(trustAnchors, (CertSelector)cs);
        pbp.addCertStore(store);
        pbp.setRevocationEnabled(false);
        CertPathBuilderResult certPath = certPathBuilder.build(pbp);
        PKIXParameters params = new PKIXParameters(trustAnchors);
        params.addCertStore(store);
        params.setTargetCertConstraints(cs);
        params.setRevocationEnabled(false);
        certPathValidator.validate(certPath.getCertPath(), params);
        log.info("Successfully validated attestion certificate chain for device [{}].", (Object)di.getDisplayName());
        return new AttestationResult(aci, registry.getIdentifier(), di, registry.getVendorInfo(), AttestationType.CERTIFICATE);
    }

    @Override
    public void validateServerCertificateChain(X509Certificate[] chain, String fqdn) throws Exception {
        CollectionCertStoreParameters cp = new CollectionCertStoreParameters(Arrays.asList(chain));
        CertStore store = CertStore.getInstance("Collection", cp);
        X509CertSelector cs = new X509CertSelector();
        cs.addSubjectAlternativeName(2, fqdn);
        PKIXBuilderParameters pbp = new PKIXBuilderParameters(jceTrustAnchors, (CertSelector)cs);
        pbp.addCertStore(store);
        pbp.setRevocationEnabled(false);
        pbp.setDate(this.validationDate);
        CertPathBuilderResult certPath = certPathBuilder.build(pbp);
        PKIXParameters params = new PKIXParameters(jceTrustAnchors);
        params.addCertStore(store);
        params.setTargetCertConstraints(cs);
        params.setRevocationEnabled(false);
        params.setDate(this.validationDate);
        certPathValidator.validate(certPath.getCertPath(), params);
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    static {
        extensionFormats = new HashMap<String, ExtensionFormat>();
        extensionFormats.put("1.3.6.1.4.1.45724.1.1.4", ExtensionFormat.OCTET_STRING);
        extensionFormats.put("1.3.6.1.4.1.45724.2.1.1", ExtensionFormat.BIT_STRING);
        extensionFormats.put("1.3.6.1.4.1.41482.2", ExtensionFormat.RAW_DATA);
        try {
            yubicoRegistry = DeviceRegistryParser.parseJson(AttestationCertValidatorImpl.class.getResourceAsStream("yubico-metadata.json"));
        }
        catch (IOException e) {
            throw new RuntimeException("Yubico device registry could not be instantiated.", e);
        }
        try {
            certPathValidator = CertPathValidator.getInstance("PKIX");
            certPathBuilder = CertPathBuilder.getInstance("PKIX");
            trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init((KeyStore)null);
            jceTrustAnchors = new HashSet<TrustAnchor>();
            for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                X509TrustManager xtm = (X509TrustManager)tm;
                for (X509Certificate ca : xtm.getAcceptedIssuers()) {
                    jceTrustAnchors.add(new TrustAnchor(ca, null));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("PKIX TrustManagerFactory could not be instantiated.", e);
        }
    }
}

