/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f.impl;

import java.security.MessageDigest;
import java.security.Signature;
import java.util.Arrays;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.common.PubKeyInfo;
import org.clazzes.login.jbo.u2f.AssertionValidator;
import org.clazzes.login.jbo.u2f.AttestedCredentialData;
import org.clazzes.login.jbo.u2f.AuthenticatorAssertionResponse;
import org.clazzes.login.jbo.u2f.AuthenticatorData;
import org.clazzes.login.jbo.u2f.AuthenticatorDataFactory;
import org.clazzes.login.jbo.u2f.PublicKeyCredential;

public class AssertionValidatorImpl
implements AssertionValidator {
    private AuthenticatorDataFactory authenticatorDataFactory;

    @Override
    public AuthenticatorData validateAssertion(PublicKeyCredential assertionCredential) throws Exception {
        byte[] credentialId = assertionCredential.getId();
        AuthenticatorAssertionResponse resp = (AuthenticatorAssertionResponse)assertionCredential.getResponse();
        AuthenticatorData assertedData = resp.parseAuthenticatorData();
        AuthenticatorData attestedData = this.authenticatorDataFactory.getAuthenticatorData(credentialId);
        if (attestedData == null) {
            throw new SecurityException("Cannot find an attestion for credential ID [" + Helpers.formatHex(credentialId) + "].");
        }
        if (!Arrays.equals(assertedData.getRpIdHash(), attestedData.getRpIdHash())) {
            throw new SecurityException("Relaying party hashes mismatch for credential ID [" + Helpers.formatHex(credentialId) + "].");
        }
        AttestedCredentialData attestedCredentialData = attestedData.getAttestedCredentialData();
        PubKeyInfo pubKey = attestedCredentialData.getCredentialPublicKey();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] clientDataHash = sha256.digest(resp.getClientData());
        Signature sig = Signature.getInstance(pubKey.getJceAlgorithm());
        sig.initVerify(pubKey.getPublicKey());
        sig.update(resp.getAuthenticatorData());
        sig.update(clientDataHash);
        boolean result = sig.verify(resp.getSignature());
        if (!result) {
            throw new SecurityException("Signatre validation failed for credential ID [" + Helpers.formatHex(credentialId) + "] and public key [" + String.valueOf(pubKey) + "].");
        }
        return attestedData;
    }

    public void setAuthenticatorDataFactory(AuthenticatorDataFactory authenticatorDataFactory) {
        this.authenticatorDataFactory = authenticatorDataFactory;
    }
}

