/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.clazzes.login.jbo.common.Helpers;

public class SafetyNetPayload {
    private final byte[] nonce;
    private final long timestampMs;
    private final String apkPackageName;
    private final byte[] apkDigestSha256;
    private final boolean ctsProfileMatch;
    private final byte[][] apkCertificateDigestSha256;
    private final boolean basicIntegrity;
    private final String evaluationType;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SafetyNetPayload(@JsonProperty(value="nonce") byte[] nonce, @JsonProperty(value="timestampMs") long timestampMs, @JsonProperty(value="apkPackageName") String apkPackageName, @JsonProperty(value="apkDigestSha256") byte[] apkDigestSha256, @JsonProperty(value="ctsProfileMatch") boolean ctsProfileMatch, @JsonProperty(value="apkCertificateDigestSha256") byte[][] apkCertificateDigestSha256, @JsonProperty(value="basicIntegrity") boolean basicIntegrity, @JsonProperty(value="evaluationType") String evaluationType) {
        this.nonce = nonce;
        this.timestampMs = timestampMs;
        this.apkPackageName = apkPackageName;
        this.apkDigestSha256 = apkDigestSha256;
        this.ctsProfileMatch = ctsProfileMatch;
        this.apkCertificateDigestSha256 = apkCertificateDigestSha256;
        this.basicIntegrity = basicIntegrity;
        this.evaluationType = evaluationType;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public long getTimestampMs() {
        return this.timestampMs;
    }

    public String getApkPackageName() {
        return this.apkPackageName;
    }

    public byte[] getApkDigestSha256() {
        return this.apkDigestSha256;
    }

    public boolean isCtsProfileMatch() {
        return this.ctsProfileMatch;
    }

    public byte[][] getApkCertificateDigestSha256() {
        return this.apkCertificateDigestSha256;
    }

    public boolean isBasicIntegrity() {
        return this.basicIntegrity;
    }

    public String getEvaluationType() {
        return this.evaluationType;
    }

    public String toString() {
        return "SafetyNetPayload [nonce=" + Helpers.formatHex(this.nonce) + ", timestampMs=" + this.timestampMs + ", apkPackageName=" + this.apkPackageName + ", apkDigestSha256=" + Helpers.formatHex(this.apkDigestSha256) + ", ctsProfileMatch=" + this.ctsProfileMatch + ", apkCertificateDigestSha256=" + Arrays.toString((Object[])this.apkCertificateDigestSha256) + ", basicIntegrity=" + this.basicIntegrity + ", evaluationType=" + this.evaluationType + "]";
    }
}

