/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.u2f.AttestationStatement;
import org.clazzes.login.jbo.u2f.SafetyNetPayload;
import org.clazzes.login.jbo.u2f.SafetyNetSignatureHeader;
import org.clazzes.login.jbo.u2f.json.CredentialParser;

public class SafetyNetAttestationStatement
extends AttestationStatement {
    public static final String FORMAT = "android-safetynet";
    private final String version;
    private final SafetyNetSignatureHeader header;
    private final SafetyNetPayload payload;
    private final byte[] signaturePayload;
    private final byte[] signature;

    public static SafetyNetAttestationStatement fromCbor(Map<String, Object> attStmt) throws Exception {
        byte[] signature = null;
        String version = (String)attStmt.get("ver");
        SafetyNetSignatureHeader header = null;
        byte[] signaturePayload = null;
        SafetyNetPayload payload = null;
        byte[] jwsResponseRaw = (byte[])attStmt.get("response");
        if (jwsResponseRaw != null) {
            int dpos = jwsResponseRaw.length;
            while (--dpos >= 0 && jwsResponseRaw[dpos] != 46) {
            }
            if (dpos < 0) {
                throw new IllegalArgumentException("android-safetynet attestation statement [response] contains JWS response without a dot.");
            }
            signaturePayload = Arrays.copyOf(jwsResponseRaw, dpos);
            String jwsResponse = new String(jwsResponseRaw, "UTF-8");
            byte[][] jwsTokens = Helpers.splitToken(jwsResponse, 3);
            if (jwsTokens.length != 3) {
                throw new IllegalArgumentException("android-safetynet attestation statement [response] contains JWS response with less than 3 parts.");
            }
            header = CredentialParser.parseSafetyNetSignatureHeader(jwsTokens[0]);
            payload = CredentialParser.parseSafetyNetPayload(jwsTokens[1]);
            signature = jwsTokens[2];
        }
        return new SafetyNetAttestationStatement(version, header, payload, signaturePayload, signature);
    }

    public SafetyNetAttestationStatement(String version, SafetyNetSignatureHeader header, SafetyNetPayload payload, byte[] signaturePayload, byte[] signature) {
        this.version = version;
        this.header = header;
        this.payload = payload;
        this.signaturePayload = signaturePayload;
        this.signature = signature;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.header == null ? null : this.header.getAlg();
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.header == null ? null : this.header.getX5c();
    }

    public String getVersion() {
        return this.version;
    }

    public SafetyNetSignatureHeader getHeader() {
        return this.header;
    }

    public SafetyNetPayload getPayload() {
        return this.payload;
    }

    public byte[] getSignaturePayload() {
        return this.signaturePayload;
    }

    public String toString() {
        return "SafetyNetAttestationStatement [version=" + this.version + ", header=" + String.valueOf(this.header) + ", payload=" + String.valueOf(this.payload) + ", signature=" + Helpers.formatHex(this.signature) + "]";
    }
}

