/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.u2f.CborHelpers;
import org.clazzes.login.jbo.u2f.FidoU2FAttestationStatement;

public class PackedAttestationStatement
extends FidoU2FAttestationStatement {
    public static final String FORMAT = "packed";
    private final Algorithm algorithm;

    public static final PackedAttestationStatement fromCbor(Map<String, Object> attStmt) throws Exception {
        Algorithm algorithm = Algorithm.getByValue((Integer)attStmt.get("alg"));
        byte[] signature = (byte[])attStmt.get("sig");
        X509Certificate[] certificateChain = CborHelpers.getCertificateChain(attStmt, "x5c");
        return new PackedAttestationStatement(algorithm, signature, certificateChain);
    }

    public PackedAttestationStatement(Algorithm algorithm, byte[] signature, X509Certificate[] certificateChain) {
        super(signature, certificateChain);
        this.algorithm = algorithm;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String toString() {
        return "PackedAttestationStatement [algorithm=" + String.valueOf((Object)this.algorithm) + ", signature=" + Helpers.formatHex(this.getSignature()) + ", certificateChain=" + Arrays.toString(this.getCertificateChain()) + "]";
    }
}

