/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.u2f.AttestationStatement;
import org.clazzes.login.jbo.u2f.CborHelpers;

public class FidoU2FAttestationStatement
extends AttestationStatement {
    public static final String FORMAT = "fido-u2f";
    private final byte[] signature;
    private final X509Certificate[] certificateChain;

    public static FidoU2FAttestationStatement fromCbor(Map<String, Object> attStmt) throws Exception {
        byte[] signature = (byte[])attStmt.get("sig");
        X509Certificate[] certificateChain = CborHelpers.getCertificateChain(attStmt, "x5c");
        return new FidoU2FAttestationStatement(signature, certificateChain);
    }

    public FidoU2FAttestationStatement(byte[] signature, X509Certificate[] certificateChain) {
        this.signature = signature;
        this.certificateChain = certificateChain;
    }

    @Override
    public Algorithm getAlgorithm() {
        return null;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    public String toString() {
        return "FidoU2FAttestationStatement [signature=" + Helpers.formatHex(this.signature) + ", certificateChain=" + Arrays.toString(this.certificateChain) + "]";
    }
}

