/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.cert.X509Certificate;
import java.util.UUID;
import org.clazzes.login.jbo.u2f.AttestationCertInfo;
import org.clazzes.login.jbo.u2f.DeviceInfo;
import org.clazzes.login.jbo.u2f.VendorInfo;

public class DeviceRegistry {
    private final UUID identifier;
    private final Integer version;
    private final VendorInfo vendorInfo;
    private final X509Certificate[] trustedCertificates;
    private final DeviceInfo[] devices;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DeviceRegistry(@JsonProperty(value="identifier") UUID identifier, @JsonProperty(value="version") Integer version, @JsonProperty(value="vendorInfo") VendorInfo vendorInfo, @JsonProperty(value="trustedCertificates") X509Certificate[] trustedCertificates, @JsonProperty(value="devices") DeviceInfo[] devices) {
        this.identifier = identifier;
        this.version = version;
        this.vendorInfo = vendorInfo;
        this.trustedCertificates = trustedCertificates;
        this.devices = devices;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public Integer getVersion() {
        return this.version;
    }

    public VendorInfo getVendorInfo() {
        return this.vendorInfo;
    }

    public X509Certificate[] getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public DeviceInfo[] getDevices() {
        return this.devices;
    }

    public DeviceInfo selectDevice(AttestationCertInfo aci) {
        if (this.devices != null) {
            for (DeviceInfo di : this.devices) {
                if (!di.matches(aci)) continue;
                return di;
            }
        }
        return null;
    }

    public DeviceInfo selectDevice(String id) {
        if (this.devices != null) {
            for (DeviceInfo di : this.devices) {
                if (!id.contentEquals(di.getDeviceId())) continue;
                return di;
            }
        }
        return null;
    }
}

