/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.clazzes.login.jbo.u2f.AttestationCertInfo;
import org.clazzes.login.jbo.u2f.DeviceSelector;
import org.clazzes.login.jbo.u2f.Transports;

public class DeviceInfo {
    private final String deviceId;
    private final String displayName;
    private final Integer transports;
    private final String deviceUrl;
    private final String imageUrl;
    private final DeviceSelector[] selectors;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DeviceInfo(@JsonProperty(value="deviceId") String deviceId, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="transports") Integer transports, @JsonProperty(value="deviceUrl") String deviceUrl, @JsonProperty(value="imageUrl") String imageUrl, @JsonProperty(value="selectors") DeviceSelector[] selectors) {
        this.deviceId = deviceId;
        this.displayName = displayName;
        this.transports = transports;
        this.deviceUrl = deviceUrl;
        this.imageUrl = imageUrl;
        this.selectors = selectors;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getTransports() {
        return this.transports;
    }

    public String formatTokenTransport() {
        return Transports.format(this.transports);
    }

    public String getDeviceUrl() {
        return this.deviceUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public DeviceSelector[] getSelectors() {
        return this.selectors;
    }

    public boolean matches(AttestationCertInfo aci) {
        if (this.selectors == null) {
            return false;
        }
        for (DeviceSelector selector : this.selectors) {
            if (selector.matches(aci)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "DeviceInfo [devieId=" + this.deviceId + ", displayName=" + this.displayName + ", transports=" + this.formatTokenTransport() + ", deviceUrl=" + this.deviceUrl + ", imageUrl=" + this.imageUrl + "]";
    }
}

