/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import org.clazzes.login.jbo.bc.BCTools;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.CurveType;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.common.KeyOperation;
import org.clazzes.login.jbo.common.KeyType;
import org.clazzes.login.jbo.common.PubKeyInfo;
import org.clazzes.login.jbo.cose.COSEKeyTypeParameter;
import org.clazzes.login.jbo.u2f.CborHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialPublicKey {
    private static final Logger log = LoggerFactory.getLogger(CredentialPublicKey.class);

    public static final PubKeyInfo parse(byte[] cborData, ParsePosition pos, int len) throws Exception {
        CurveType ct;
        Map top;
        CBORMapper mapper = (CBORMapper)CBORMapper.builder().build();
        ObjectReader reader = mapper.readerFor(Map.class);
        try (ByteArrayInputStream is = new ByteArrayInputStream(cborData, pos.getIndex(), len);){
            top = (Map)reader.readValue((InputStream)is);
        }
        if (log.isDebugEnabled()) {
            log.debug("CredentialPublicKey.parse: top = {}", (Object)top);
        }
        KeyType keyType = KeyType.getByValue((Integer)top.get("1"));
        String kid = Helpers.formatBase64((byte[])top.get("2"));
        Algorithm algorithm = Algorithm.getByValue((Integer)top.get("3"));
        KeyOperation[] keyOperations = CborHelpers.getKeyOpsArray(top, "4");
        HashMap paramValues = new HashMap();
        for (Map.Entry e : top.entrySet()) {
            int n = Integer.parseInt((String)e.getKey());
            if (n >= 1 && n <= 5) continue;
            COSEKeyTypeParameter parameter = COSEKeyTypeParameter.getByKeyTypeAndLabel(keyType, n);
            paramValues.put(parameter, e.getValue());
        }
        return new PubKeyInfo(kid, keyType, ct, algorithm, keyOperations, switch (keyType) {
            case KeyType.RSA -> {
                BigInteger n = new BigInteger(1, (byte[])paramValues.get((Object)COSEKeyTypeParameter.RSA_N));
                BigInteger e = new BigInteger(1, (byte[])paramValues.get((Object)COSEKeyTypeParameter.RSA_E));
                RSAPublicKeySpec pks = new RSAPublicKeySpec(n, e);
                KeyFactory kf = KeyFactory.getInstance("RSA");
                ct = null;
                yield kf.generatePublic(pks);
            }
            case KeyType.EC2 -> {
                ECPoint p;
                ct = CurveType.getByValue((Integer)paramValues.get((Object)COSEKeyTypeParameter.EC2_CRV));
                BigInteger x = new BigInteger(1, (byte[])paramValues.get((Object)COSEKeyTypeParameter.EC2_X));
                Object yitem = paramValues.get((Object)COSEKeyTypeParameter.EC2_Y);
                if (yitem instanceof Boolean) {
                    Boolean ytilde = (Boolean)yitem;
                    p = BCTools.decompressPoint(ct, x, ytilde);
                } else {
                    BigInteger y = new BigInteger(1, (byte[])yitem);
                    p = new ECPoint(x, y);
                }
                AlgorithmParameters ap = AlgorithmParameters.getInstance("EC");
                ap.init(new ECGenParameterSpec(ct.getJceType()));
                ECParameterSpec ecps = ap.getParameterSpec(ECParameterSpec.class);
                ECPublicKeySpec pks = new ECPublicKeySpec(p, ecps);
                KeyFactory kf = KeyFactory.getInstance("EC");
                yield kf.generatePublic(pks);
            }
            case KeyType.OKP -> {
                ct = CurveType.getByValue((Integer)paramValues.get((Object)COSEKeyTypeParameter.OKP_CRV));
                if (ct.getJceType() != null) {
                    throw new IllegalArgumentException("EC Curve [" + ct.getJceType() + "] specified, where EdEC curve expected.");
                }
                byte[] x = (byte[])paramValues.get((Object)COSEKeyTypeParameter.OKP_X);
                X509EncodedKeySpec pks = new X509EncodedKeySpec(x);
                KeyFactory kf = KeyFactory.getInstance(ct.getJwkType());
                yield kf.generatePublic(pks);
            }
            default -> throw new IllegalArgumentException("Unsupported key type [" + String.valueOf((Object)keyType) + "] specified.");
        });
    }
}

