/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.clazzes.login.jbo.common.KeyOperation;

public abstract class CborHelpers {
    public static X509Certificate[] getCertificateChain(Map<String, Object> attStmt, String key) throws Exception {
        List x5c = (List)attStmt.get(key);
        X509Certificate[] certificateChain = null;
        if (x5c != null) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificateChain = new X509Certificate[x5c.size()];
            for (int i = 0; i < x5c.size(); ++i) {
                byte[] c = (byte[])x5c.get(i);
                try (ByteArrayInputStream bis = new ByteArrayInputStream(c);){
                    certificateChain[i] = (X509Certificate)cf.generateCertificate(bis);
                    continue;
                }
            }
        }
        return certificateChain;
    }

    public static final KeyOperation[] getKeyOpsArray(Map<String, Object> pk, String key) {
        List arr = (List)pk.get(key);
        KeyOperation[] ret = null;
        if (arr != null) {
            ret = new KeyOperation[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                ret[i] = KeyOperation.getByValue((Integer)arr.get(i));
            }
        }
        return ret;
    }
}

