/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import java.text.ParsePosition;
import java.util.Arrays;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.u2f.AttestedCredentialData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorData {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorData.class);
    public static final int FLAG_UP = 1;
    public static final int FLAG_UV = 4;
    public static final int FLAG_AT = 64;
    public static final int FLAG_ED = 128;
    private final byte[] rpIdHash;
    private final int flags;
    private final long signCount;
    private final AttestedCredentialData attestedCredentialData;

    public static AuthenticatorData parse(byte[] in) throws Exception {
        ParsePosition pos = new ParsePosition(0);
        if (pos.getIndex() + 32 > in.length) {
            throw new IllegalArgumentException("Authenticator Data of length [" + in.length + "] is too short for 32-byte rpIdHash.");
        }
        byte[] rpIdHash = Arrays.copyOfRange(in, pos.getIndex(), pos.getIndex() + 32);
        pos.setIndex(pos.getIndex() + 32);
        if (pos.getIndex() + 1 > in.length) {
            throw new IllegalArgumentException("Authenticator Data of length [" + in.length + "] is too short for 1-byte flags.");
        }
        int flags = in[pos.getIndex()] & 0xFF;
        pos.setIndex(pos.getIndex() + 1);
        if (pos.getIndex() + 4 > in.length) {
            throw new IllegalArgumentException("Authenticator Data of length [" + in.length + "] is too short for 4-byte signCount.");
        }
        long signCount = ((long)in[pos.getIndex()] & 0xFFL) << 24 | ((long)in[pos.getIndex() + 1] & 0xFFL) << 16 | ((long)in[pos.getIndex() + 2] & 0xFFL) << 8 | (long)in[pos.getIndex() + 3] & 0xFFL;
        pos.setIndex(pos.getIndex() + 4);
        AttestedCredentialData attestedCredentialData = null;
        if (pos.getIndex() < in.length) {
            attestedCredentialData = AttestedCredentialData.parse(in, pos, in.length - pos.getIndex());
        }
        if (pos.getIndex() < in.length) {
            log.warn("Ignoring [{}] bytes of extension data", (Object)(in.length - pos.getIndex()));
        }
        return new AuthenticatorData(rpIdHash, flags, signCount, attestedCredentialData);
    }

    public AuthenticatorData(byte[] rpIdHash, int flags, long signCount, AttestedCredentialData attestedCredentialData) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = signCount;
        this.attestedCredentialData = attestedCredentialData;
    }

    public byte[] getRpIdHash() {
        return this.rpIdHash;
    }

    public int getFlags() {
        return this.flags;
    }

    public String formatFlags() {
        StringBuffer sb = new StringBuffer();
        if (this.isUserPresent()) {
            sb.append("UP");
        }
        if (this.isUserVerified()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("UV");
        }
        if (this.isAttestedCredentialDataPresent()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("AT");
        }
        if (this.isExtensionDataPresent()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("ED");
        }
        return sb.toString();
    }

    public boolean isUserPresent() {
        return (this.flags & 1) != 0;
    }

    public boolean isUserVerified() {
        return (this.flags & 4) != 0;
    }

    public boolean isAttestedCredentialDataPresent() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isExtensionDataPresent() {
        return (this.flags & 0x80) != 0;
    }

    public long getSignCount() {
        return this.signCount;
    }

    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public String toString() {
        return "AuthenticatorData [rpIdHash=" + Helpers.formatHex(this.rpIdHash) + ", flags=" + this.formatFlags() + ", signCount=" + this.signCount + ", attestedCredentialData=" + String.valueOf(this.attestedCredentialData) + "]";
    }
}

