/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import java.text.ParsePosition;
import java.util.Arrays;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.common.PubKeyInfo;
import org.clazzes.login.jbo.u2f.CredentialPublicKey;

public class AttestedCredentialData {
    private final byte[] aaguid;
    private final byte[] credentialId;
    private final PubKeyInfo credentialPublicKey;

    public static final AttestedCredentialData parse(byte[] in, ParsePosition pos, int len) throws Exception {
        int end = pos.getIndex() + len;
        if (pos.getIndex() + 16 > end) {
            throw new IllegalArgumentException("Attested Credential Data of length [" + len + "] is too short for 16-byte aaguid.");
        }
        byte[] aaguid = Arrays.copyOfRange(in, pos.getIndex(), pos.getIndex() + 16);
        pos.setIndex(pos.getIndex() + 16);
        if (pos.getIndex() + 2 > end) {
            throw new IllegalArgumentException("Attested Credential Data of length [" + len + "] is too short for 2-byte credentialId length.");
        }
        int l = ((in[pos.getIndex()] & 0xFF) << 8) + (in[pos.getIndex() + 1] & 0xFF);
        pos.setIndex(pos.getIndex() + 2);
        if (pos.getIndex() + l > end) {
            throw new IllegalArgumentException("Attested Credential Data of length [" + len + "] is too short for credentialId of length [" + l + "].");
        }
        byte[] credentialId = Arrays.copyOfRange(in, pos.getIndex(), pos.getIndex() + l);
        pos.setIndex(pos.getIndex() + l);
        PubKeyInfo credentialPublicKey = CredentialPublicKey.parse(in, pos, end - pos.getIndex());
        return new AttestedCredentialData(aaguid, credentialId, credentialPublicKey);
    }

    public AttestedCredentialData(byte[] aaguid, byte[] credentialId, PubKeyInfo credentialPublicKey) {
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.credentialPublicKey = credentialPublicKey;
    }

    public PubKeyInfo getCredentialPublicKey() {
        return this.credentialPublicKey;
    }

    public byte[] getAaguid() {
        return this.aaguid;
    }

    public byte[] getCredentialId() {
        return this.credentialId;
    }

    public String toString() {
        return "AttestedCredentialData [aaguid=" + Helpers.formatHex(this.aaguid) + ", credentialId=" + Helpers.formatHex(this.credentialId) + ", credentialPublicKey=" + String.valueOf(this.credentialPublicKey) + "]";
    }
}

