/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.u2f;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import java.util.Map;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.u2f.AttestationStatement;
import org.clazzes.login.jbo.u2f.AuthenticatorData;
import org.clazzes.login.jbo.u2f.FidoU2FAttestationStatement;
import org.clazzes.login.jbo.u2f.PackedAttestationStatement;
import org.clazzes.login.jbo.u2f.SafetyNetAttestationStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttestationObject {
    private static final Logger log = LoggerFactory.getLogger(AttestationObject.class);
    private final byte[] authData;
    private final AttestationStatement attStmt;
    private AuthenticatorData parsedAuthData;

    public static AttestationObject parse(byte[] cborData) throws Exception {
        CBORMapper mapper = (CBORMapper)CBORMapper.builder().build();
        ObjectReader reader = mapper.readerFor(Map.class);
        Map top = (Map)reader.readValue(cborData);
        if (log.isDebugEnabled()) {
            log.debug("AttestationObject.parse: top = {}", (Object)top);
        }
        byte[] authData = (byte[])top.get("authData");
        Map attStmtItem = (Map)top.get("attStmt");
        String attStmtFmt = (String)top.get("fmt");
        AttestationStatement attStmt = null;
        if ("packed".equals(attStmtFmt)) {
            attStmt = PackedAttestationStatement.fromCbor(attStmtItem);
        } else if ("fido-u2f".equals(attStmtFmt)) {
            attStmt = FidoU2FAttestationStatement.fromCbor(attStmtItem);
        } else if ("android-safetynet".equals(attStmtFmt)) {
            attStmt = SafetyNetAttestationStatement.fromCbor(attStmtItem);
        } else {
            throw new IllegalArgumentException("Unsupported attestation statement format [" + attStmtFmt + "] in attestation object.");
        }
        return new AttestationObject(authData, attStmt);
    }

    public AttestationObject(byte[] authData, AttestationStatement attStmt) {
        this.authData = authData;
        this.attStmt = attStmt;
    }

    public byte[] getAuthData() {
        return this.authData;
    }

    public AuthenticatorData parseAuthData() throws Exception {
        if (this.authData == null) {
            return null;
        }
        if (this.parsedAuthData == null) {
            this.parsedAuthData = AuthenticatorData.parse(this.authData);
        }
        return this.parsedAuthData;
    }

    public AttestationStatement getAttStmt() {
        return this.attStmt;
    }

    public String toString() {
        return "AttestationObject [authData=" + Helpers.formatHex(this.authData) + ", attStmt=" + String.valueOf(this.attStmt) + "]";
    }
}

