/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.jwt;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.json.JsonHelper;
import org.clazzes.login.jbo.jwt.JWToken;
import org.clazzes.login.jbo.jwt.JWTokenClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTokenParser {
    private static final Logger log = LoggerFactory.getLogger(JWTokenParser.class);

    public static Map<String, Object> parseObject(JsonParser p, String ctxt) throws IOException {
        String key;
        HashMap<String, Object> kvs = new HashMap<String, Object>();
        while ((key = JsonHelper.nextName(p, ctxt)) != null) {
            Object value = JWTokenParser.parsePrimitive(p, key);
            if (value == null) continue;
            kvs.put(key, value);
        }
        JsonHelper.endObject(p, ctxt);
        return kvs;
    }

    private static Object parsePrimitive(JsonParser reader, String name) throws IOException {
        String ctxt = "JWToken.additionalClaims." + name;
        switch (reader.nextToken()) {
            case VALUE_NUMBER_INT: {
                return reader.getLongValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return reader.getDoubleValue();
            }
            case VALUE_STRING: {
                return reader.getText();
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return reader.getBooleanValue();
            }
            case START_ARRAY: {
                String a;
                ArrayList<String> values = new ArrayList<String>();
                while ((a = reader.nextTextValue()) != null) {
                    values.add(a);
                }
                JsonHelper.endArray(reader, ctxt);
                return values;
            }
            case START_OBJECT: {
                return JWTokenParser.parseObject(reader, ctxt);
            }
        }
        log.warn("Ignoring token claim [{}], which is not of type string, number, string-array, map-of-primitives or boolean", (Object)name);
        reader.skipChildren();
        return null;
    }

    private static void writeIfNotNull(JsonGenerator writer, String key, String value) throws IOException {
        if (value != null) {
            writer.writeFieldName(key);
            writer.writeString(value);
        }
    }

    private static void writeIfNotNull(JsonGenerator writer, String key, List<String> value) throws IOException {
        if (value != null) {
            writer.writeFieldName(key);
            if (value.size() == 1) {
                writer.writeString(value.get(0));
            } else {
                writer.writeStartArray();
                for (String v : value) {
                    writer.writeString(v);
                }
                writer.writeEndArray();
            }
        }
    }

    private static void writeIfNotNull(JsonGenerator writer, String key, Long value) throws IOException {
        if (value != null) {
            writer.writeFieldName(key);
            writer.writeNumber(value / 1000L);
        }
    }

    public static final JWToken parseJWToken(String token) throws IOException {
        byte[][] parts = Helpers.splitToken(token, 3);
        if (parts.length != 3) {
            throw new IllegalArgumentException("JWT Token is not composed of three dot-separated parts.");
        }
        Algorithm algorithm = null;
        String keyId = null;
        byte[] signaturePayload = token.substring(0, token.lastIndexOf(46)).getBytes("US-ASCII");
        byte[] signature = parts[2];
        JsonFactory jf = new JsonFactory();
        try (JsonParser reader = jf.createParser((InputStream)new ByteArrayInputStream(parts[0]));){
            String name;
            String ctxt = "JWTTokenHeader";
            JsonHelper.beginObject(reader, ctxt);
            while ((name = JsonHelper.nextName(reader, ctxt)) != null) {
                if ("kid".equals(name)) {
                    keyId = JsonHelper.nextString(reader, ctxt);
                    continue;
                }
                if ("alg".equals(name)) {
                    String rawAlgorithm = JsonHelper.nextString(reader, ctxt);
                    algorithm = Algorithm.valueOf(rawAlgorithm);
                    continue;
                }
                if ("typ".equals(name)) {
                    String typ = JsonHelper.nextString(reader, ctxt);
                    if ("JWT".equals(typ)) continue;
                    throw new IllegalArgumentException("JWT Token has invalid type [" + typ + "].");
                }
                log.warn("Invalid attribute [{}] in JSON Web Key.", (Object)name);
                reader.nextToken();
                reader.skipChildren();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing JWT Token header.", e);
        }
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule cm = new SimpleModule();
        cm.addDeserializer(JWTokenClaims.class, (JsonDeserializer)new JWTTokenClaimsDeserializer());
        mapper.registerModule((Module)cm);
        JWTokenClaims claims = (JWTokenClaims)mapper.readValue(parts[1], JWTokenClaims.class);
        return new JWToken(algorithm, keyId, claims, signaturePayload, signature);
    }

    public static byte[] formatSignaturePayload(Algorithm algorithm, String keyId, JWTokenClaims claims) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JsonFactory jf = new JsonFactory();
        try (JsonGenerator writer = jf.createGenerator((OutputStream)bos);){
            writer.writeStartObject();
            writer.writeFieldName("typ");
            writer.writeString("JWT");
            writer.writeFieldName("alg");
            writer.writeString(algorithm.toString());
            writer.writeFieldName("kid");
            writer.writeString(keyId);
            writer.writeEndObject();
        }
        String part1 = Helpers.formatBase64(bos.toByteArray());
        bos.reset();
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule sm = new SimpleModule();
        sm.addSerializer((JsonSerializer)new JWTTokenClaimsSerializer());
        mapper.registerModule((Module)sm);
        mapper.writeValue((OutputStream)bos, (Object)claims);
        String part2 = Helpers.formatBase64(bos.toByteArray());
        byte[] ret = new byte[part1.length() + 1 + part2.length()];
        System.arraycopy(part1.getBytes("US-ASCII"), 0, ret, 0, part1.length());
        ret[part1.length()] = 46;
        System.arraycopy(part2.getBytes("US-ASCII"), 0, ret, part1.length() + 1, part2.length());
        return ret;
    }

    public static String formatSignedToken(JWToken token) throws UnsupportedEncodingException {
        return new String(token.getSignaturePayload(), "US-ASCII") + "." + Helpers.formatBase64(token.getSignature());
    }

    private static final class JWTTokenClaimsDeserializer
    extends JsonDeserializer<JWTokenClaims> {
        private JWTTokenClaimsDeserializer() {
        }

        public JWTokenClaims deserialize(JsonParser p, DeserializationContext dctxt) throws IOException, JacksonException {
            String name;
            String ctxt = "JWTTokenClaims";
            String jwtId = null;
            String issuer = null;
            String subject = null;
            List<Object> audience = null;
            Long issuedAt = null;
            Long notBefore = null;
            Long expiration = null;
            TreeMap<String, Object> additionalClaims = new TreeMap<String, Object>();
            JsonHelper.beginObject(p, ctxt);
            while ((name = JsonHelper.nextName(p, ctxt)) != null) {
                if ("aud".equals(name)) {
                    JsonToken token = p.nextToken();
                    if (token == JsonToken.START_ARRAY) {
                        String a;
                        audience = new ArrayList();
                        while ((a = p.nextTextValue()) != null) {
                            audience.add(a);
                        }
                        JsonHelper.endArray(p, ctxt);
                        continue;
                    }
                    if (token == JsonToken.VALUE_STRING) {
                        audience = Collections.singletonList(p.getText());
                        continue;
                    }
                    throw new IllegalArgumentException("JWT Token claims 'aud' has is neither a string nor an array.");
                }
                if ("iss".equals(name)) {
                    issuer = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("sub".equals(name)) {
                    subject = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("jti".equals(name)) {
                    jwtId = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("iat".equals(name)) {
                    issuedAt = JsonHelper.nextLong(p, ctxt) * 1000L;
                    continue;
                }
                if ("nbf".equals(name)) {
                    notBefore = JsonHelper.nextLong(p, ctxt) * 1000L;
                    continue;
                }
                if ("exp".equals(name)) {
                    expiration = JsonHelper.nextLong(p, ctxt) * 1000L;
                    continue;
                }
                Object v = JWTokenParser.parsePrimitive(p, name);
                additionalClaims.put(name, v);
            }
            return new JWTokenClaims(jwtId, issuer, subject, audience, issuedAt, notBefore, expiration, additionalClaims);
        }
    }

    private static final class JWTTokenClaimsSerializer
    extends JsonSerializer<JWTokenClaims> {
        private JWTTokenClaimsSerializer() {
        }

        public Class<JWTokenClaims> handledType() {
            return JWTokenClaims.class;
        }

        public void serialize(JWTokenClaims claims, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            JWTokenParser.writeIfNotNull(gen, "aud", claims.getAudience());
            JWTokenParser.writeIfNotNull(gen, "iss", claims.getIssuer());
            JWTokenParser.writeIfNotNull(gen, "sub", claims.getSubject());
            JWTokenParser.writeIfNotNull(gen, "jti", claims.getJwtId());
            JWTokenParser.writeIfNotNull(gen, "iat", claims.getIssuedAt());
            JWTokenParser.writeIfNotNull(gen, "nbf", claims.getNotBefore());
            JWTokenParser.writeIfNotNull(gen, "exp", claims.getExpiration());
            if (claims.getAdditionalClaims() != null) {
                for (Map.Entry<String, Object> e : claims.getAdditionalClaims().entrySet()) {
                    gen.writeFieldName(e.getKey());
                    gen.writePOJO(e.getValue());
                }
            }
            gen.writeEndObject();
        }
    }
}

